

<?php $__env->startSection('content'); ?>
    <style>
        .inquiry-only {
            background-color: lightyellow;
        }

        .appointment-scheduled {
            background-color: lightblue;
        }

        .appointment-completed {
            background-color: lightgreen;
        }

        .appointment-cancelled {
            background-color: lightcoral;
        }

        .followup-scheduled {
            background-color: lightpink;
        }

        .followup-completed {
            background-color: lightseagreen;
        }

        .not-interested {
            background-color: lightgrey;
        }
    </style>
    <div class="col-sm-12 col-md-12">
        <h3 class="heading">Add Follow-up Pt. Details</h3>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('success')): ?>
            <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php elseif(session('error')): ?>
            <div id="response-message" class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>
        <form id="enquiryForm" class="form_validation_reg" action="<?php echo e(route('followup.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="formSep">
                <div class="row">
                    <div class="col-sm-2 col-md-2">
                        <label>Name* <span class="f_req">*</span></label>
                        <input name="name" class="form-control" type="text">
                    </div>
                    <div class="col-sm-2 col-md-2">
                        <label>Phone* <span class="f_req">*</span></label>
                        <input name="phone" class="form-control" type="text">
                    </div>


                    <div class="col-sm-3 col-md-3">
                        <label>Doctor Name <span class="f_req">*</span></label>
                        <select name="doctor" id="doctor" class="form-control">
                            <option value="">--Select--</option>
                            <option value="InternalMedicine">Dr. Vinod</option>
                            <option value="InternalMedicine">Dr. Kunal Kothari</option>
                            <option value="Gynaecology">Dr. Garima Singh</option>
                            <option value="Gynaecology">Dr. Kiran Yadav</option>
                            <option value="Surgery">Dr. Gaurav Bansal</option>
                            <option value="Surgery">Dr. Rohit Jain</option>
                            <option value="Surgery">Dr. Kaushal Yadav</option>
                            <option value="Orthopaedics">Dr. Anubhav Gulati</option>
                            <option value="Orthopaedics">Dr. Abhinav</option>
                            <option value="Paediatrics">Dr. Sachin Jain</option>
                            <option value="Paediatrics">Dr. Shiwani Mangla</option>
                            <option value="ENT">Dr. Abhimanyu</option>
                            <option value="Physiotherapy">Dr. Yash Fauzdar</option>
                            <option value="Dental">Dr. Prerna Sharma</option>
                            <option value="Dermatology">Dr. Ashish Bhagat</option>
                            <option value="Dietitian">Dr. Deepika Sharma</option>
                        </select>
                    </div>
                    <div class="col-sm-3 col-md-3">
                        <label>Department <span class="f_req">*</span></label>
                        <select name="department" id="department" class="form-control">
                            <option value="">--Select--</option>
                            <option value="InternalMedicine">Internal Medicine</option>
                            <option value="Gynaecology">Gynaecology</option>
                            <option value="Surgery">Surgery</option>
                            <option value="Orthopaedics">Orthopaedics</option>
                            <option value="Paediatrics">Paediatrics</option>
                            <option value="ENT">ENT</option>
                            <option value="Physiotherapy">Physiotherapy</option>
                            <option value="Dialysis">Dialysis</option>
                            <option value="Dental">Dental</option>
                            <option value="Dermatology">Dermatology</option>
                            <option value="ICU">ICU</option>
                            <option value="Dietitian">Dietitian</option>
                            <option value="X-ray">X-Ray</option>
                            <option value="Ultrasound">Ultra-sound</option>
                        </select>
                    </div>

                    <div class="col-sm-2 col-md-2">
                        <label for="interest-select">Status</label>
                        <select name="status" id="status-select" class="form-control" onchange="updateBackgroundColor()">
                            <option value="">-select-</option>
                            <option value="InquiryOnly" class="inquiry-only">Inquiry Only</option>
                            <option value="AppointmentScheduled" class="appointment-scheduled">Appointment Scheduled
                            </option>
                            <option value="AppointmentCompleted" class="appointment-completed">Appointment Completed
                            </option>
                            <option value="AppointmentCancelled" class="appointment-cancelled">Appointment Cancelled
                            </option>
                            <option value="FollowUpScheduled" class="followup-scheduled">Follow-Up Scheduled</option>
                            <option value="FollowUpCompleted" class="followup-completed">Follow-Up Completed</option>
                            <option value="NotInterested" class="not-interested">Not Interested</option>
                        </select>
                    </div>

                    <div class="formSep col-sm-12 col-md-12">
                        <label>Remark <span class="f_req">*</span></label>
                        <textarea name="remark" id="remark" cols="10" rows="3" class="form-control"></textarea>
                    </div>

                    <div class="form-actions col-sm-12 col-md-12">
                        <button class="btn btn-primary" type="submit">Save & Add Next</button>
                        <button class="btn btn-default" type="reset">Cancel</button>
                    </div>
                </div>
                <script>
                    document.getElementById('doctor').addEventListener('change', function() {
                        var departmentSelect = document.getElementById('department');
                        var selectedDoctor = this.value;

                        // Reset the department select options
                        departmentSelect.value = "";

                        // If selectedDoctor is ICU or X-ray, set the department to null and disable it
                        if (selectedDoctor === "ICU" || selectedDoctor === "X-ray") {
                            departmentSelect.innerHTML = '<option value="">--Select--</option>';
                            departmentSelect.disabled = true;
                        } else {
                            // Enable the department select and populate the options
                            departmentSelect.disabled = false;

                            // Create an array of all department options
                            var departmentOptions = [{
                                    value: "InternalMedicine",
                                    text: "Internal Medicine"
                                },
                                {
                                    value: "Gynaecology",
                                    text: "Gynaecology"
                                },
                                {
                                    value: "Surgery",
                                    text: "Surgery"
                                },
                                {
                                    value: "Orthopaedics",
                                    text: "Orthopaedics"
                                },
                                {
                                    value: "Paediatrics",
                                    text: "Paediatrics"
                                },
                                {
                                    value: "ENT",
                                    text: "ENT"
                                },
                                {
                                    value: "Physiotherapy",
                                    text: "Physiotherapy"
                                },
                                {
                                    value: "Dialysis",
                                    text: "Dialysis"
                                },
                                {
                                    value: "Dental",
                                    text: "Dental"
                                },
                                {
                                    value: "Dermatology",
                                    text: "Dermatology"
                                },
                                {
                                    value: "ICU",
                                    text: "ICU"
                                },
                                {
                                    value: "Dietitian",
                                    text: "Dietitian"
                                },
                                {
                                    value: "X-ray",
                                    text: "X-Ray"
                                },
                                {
                                    value: "Ultrasound",
                                    text: "Ultra-sound"
                                }
                            ];

                            // Populate the department select with options
                            departmentSelect.innerHTML = '<option value="">--Select--</option>';
                            departmentOptions.forEach(function(option) {
                                var optionElement = document.createElement('option');
                                optionElement.value = option.value;
                                optionElement.textContent = option.text;
                                departmentSelect.appendChild(optionElement);
                            });

                            // Automatically select the department based on the selected doctor
                            for (var i = 0; i < departmentSelect.options.length; i++) {
                                if (departmentSelect.options[i].value === selectedDoctor) {
                                    departmentSelect.selectedIndex = i;
                                    break;
                                }
                            }
                        }
                    });
                </script>


            </div>


        </form>
        <div id="response-message" class="alert" style="display:none;"></div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#enquiryForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission

                $.ajax({
                    url: $(this).attr('action'), // Use the form's action attribute
                    method: 'POST',
                    data: $(this).serialize(),
                    success: function(response) {
                        if (response.success) {
                            $('#response-message').removeClass('alert-danger').addClass(
                                'alert-success').html(response.success).show();
                            $('#enquiryForm')[0].reset(); // Clear the form
                        } else if (response.error) {
                            $('#response-message').removeClass('alert-success').addClass(
                                'alert-danger').html(response.error).show();
                        }
                    },
                    error: function(response) {
                        $('#response-message').removeClass('alert-success').addClass(
                                'alert-danger').html('An error occurred. Please try again.')
                            .show();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/followup/create.blade.php ENDPATH**/ ?>