

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Total Device Overview Section -->
    <h3 class="heading text-center mb-4">Total Device Overview</h3>
    <div class="row text-center mb-5">
        <!-- Total Devices -->
        <div class="col-md-2 mb-4">
            <a href="<?php echo e(route('laptop_tracker.index')); ?>"> <!-- Link to show all devices -->
                <div class="card shadow-sm overview-card">
                    <div class="card-body">
                        <h5 class="card-title text-primary"><i class="fas fa-server"></i> Total Devices</h5>
                        <h4><?php echo e($totalDevices); ?></h4>
                    </div>
                </div>
            </a>
        </div>
        <!-- Each Device Category (Laptops, Desktops, etc.) -->
        <div class="col-md-2 mb-4">
            <a href="<?php echo e(route('devices.laptops')); ?>"> <!-- Link to show laptops -->
                <div class="card shadow-sm overview-card">
                    <div class="card-body">
                        <h5 class="card-title text-success"><i class="fas fa-laptop"></i> Total Laptops</h5>
                        <h4><?php echo e($totalLaptops); ?></h4>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-2 mb-4">
            <a href="<?php echo e(route('devices.desktops')); ?>"> <!-- Link to show desktops -->
                <div class="card shadow-sm overview-card">
                    <div class="card-body">
                        <h5 class="card-title text-warning"><i class="fas fa-desktop"></i>Total Desktops</h5>
                        <h4><?php echo e($totalDesktops); ?></h4>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-2 mb-4">
            <a href="<?php echo e(route('devices.tablets')); ?>"> <!-- Link to show tablets -->
                <div class="card shadow-sm overview-card">
                    <div class="card-body">
                        <h5 class="card-title text-danger"><i class="fas fa-tablet-alt"></i> Total Tablets</h5>
                        <h4><?php echo e($totalTablets); ?></h4>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-2 mb-4">
            <a href="<?php echo e(route('devices.mobiles')); ?>"> <!-- Link to show mobiles -->
                <div class="card shadow-sm overview-card">
                    <div class="card-body">
                        <h5 class="card-title text-info"><i class="fas fa-mobile-alt"></i> Total Mobiles</h5>
                        <h4><?php echo e($totalMobiles); ?></h4>
                    </div>
                </div>
            </a>
        </div>
    </div>
    <br>

    <!-- Department-wise Device Breakdown Section with Collapsible Panels -->
    <h4 class="heading text-center mt-5 mb-4">Department-wise Device Breakdown</h4>
    <div class="row">
        <?php $__currentLoopData = $deviceCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deviceCount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-3">
            <div class="card department-card mb-4 shadow-sm">
                <div class="card-header bg-darkblue text-white">
                    <h5 class="card-title mb-0 d-flex justify-content-between">
                        <?php echo e($deviceCount->department); ?> :
                        <span class="badge badge-light blinking-badge"><?php echo e($deviceCount->laptop_count); ?> Systems</span>
                    </h5>
                    <button class="btn btn-danger btn-sm float-right" type="button" data-toggle="collapse"
                        data-target="#collapse-<?php echo e($loop->index); ?>" aria-expanded="false"
                        aria-controls="collapse-<?php echo e($loop->index); ?>">
                        Details <i class="fas fa-chevron-down"></i>
                    </button>
                </div>
                <div id="collapse-<?php echo e($loop->index); ?>" class="collapse">
                    <div class="card-body">
                        <div class="device-stats d-flex justify-content-between">
                            <div class="stat-item text-center">
                                <i class="fas fa-laptop fa-2x text-primary"></i>
                                <p class="mb-0">Laptops</p>
                                <h4><?php echo e($deviceCount->laptop_count); ?></h4>
                            </div>
                            <div class="stat-item text-center">
                                <i class="fas fa-desktop fa-2x text-success"></i>
                                <p class="mb-0">Desktops</p>
                                <h4><?php echo e($deviceCount->desktop_count); ?></h4>
                            </div>
                            <div class="stat-item text-center">
                                <i class="fas fa-mobile-alt fa-2x text-info"></i>
                                <p class="mb-0">Mobiles</p>
                                <h4><?php echo e($deviceCount->mobile_count); ?></h4>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-center">
                        <a href="<?php echo e(route('devices.department', $deviceCount->department)); ?>"
                            class="btn btn-outline-primary btn-sm">
                            View Employees <i class="fas fa-users"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<!-- Improved Styling with Professional Colors -->
<style>
    /* Section Heading */
    .heading {
        font-size: 1.8rem;
        font-weight: 700;
        color: #1e3a8a; /* Dark Blue */
        margin-bottom: 2rem;
        text-transform: uppercase;
    }

    /* Overview Card Styles */
    .overview-card {
        border-radius: 8px;
        padding: 1.5rem;
        background-color: #f9f9f9;
        transition: transform 0.3s ease;
    }

    .overview-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 10px 20px rgba(145, 10, 10, 0.1);
    }

    /* Department Card Styles */
    .department-card {
        border-radius: 10px;
        transition: box-shadow 0.3s ease;
        background: #eef2ff; /* Light blue background for department cards */
    }

    .department-card .card-header {
        background-color: #067EAD; /* Dark Blue for department header */
        color: #fff;
        padding: 1rem;
    }

    .department-card .btn {
        margin-left: auto;
        font-size: 0.9rem;
    }

    .department-card .card-body {
        padding: 1.5rem;
        background-color: #f1f1f1;
    }

    .department-card .card-footer {
        background-color: #e9ecef;
        padding: 0.75rem;
    }

    .device-stats {
        display: flex;
        justify-content: space-between;
    }

    .stat-item {
        text-align: center;
    }

    .stat-item i {
        margin-bottom: 0.5rem;
        display: block;
    }

    .stat-item p {
        font-size: 0.9rem;
        margin: 0;
    }

    .stat-item h4 {
        margin-top: 0.5rem;
        font-weight: 600;
    }

    /* Custom Colors */
    .bg-darkblue {
        background-color: #1e3a8a; /* Dark Blue */
    }

    /* Badge for laptop count */
    .badge {
        font-size: 1rem;
        padding: 0.4rem 0.75rem;
    }

    /* Collapse Transition */
    .collapse {
        transition: all 0.4s ease-in-out;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .device-stats {
            flex-direction: column;
        }
    }

@keyframes blink-bg {
    0% {
        background-color: #ff5722;  
    }
    50% {
        background-color: #b69309; 
    }
    100% {
        background-color: #ff5722; 
    }
}

.badge.blinking-badge {
    color: white;
    animation: blink-bg 1.5s infinite; 
    padding: 0.5rem 1rem;
    border-radius: 20%;
    font-size: 1rem;
     transition: background-color 0.5s ease-in-out;
     box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;
}

</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/software.madalasahospital.com/resources/views/pages/laptop_tracker/dashboard.blade.php ENDPATH**/ ?>