

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Edit Laptop Assignment</h3>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <form id="laptopEditForm" class="form_validation_reg" action="<?php echo e(route('laptop_tracker.update', $laptop->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="formSep">
            <div class="row">
                <div class="col-sm-2 col-md-2">
                    <label>Select Employee <span class="f_req">*</span></label>
                    <div class="input-group">
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>" <?php echo e($employee->id == $laptop->employee_id ? 'selected' : ''); ?> data-phone="<?php echo e($employee->phone); ?>" data-emergency="<?php echo e($employee->emergency_contact_number); ?>" data-email="<?php echo e($employee->email); ?>">
                                    <?php echo e($employee->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="input-group-btn">
                            <button class="btn btn-secondary" type="button" data-toggle="modal" data-target="#employeeModal">
                                <i class="fas fa-search"></i>
                            </button>
                        </span>
                    </div>
                </div>
                <!-- Other input fields similar to the create form -->
                <div class="col-sm-2 col-md-2">
                    <label>Serial Number <span class="f_req">*</span></label>
                    <input name="serial_number" class="form-control" type="text" value="<?php echo e($laptop->serial_number); ?>" required>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Laptop Type <span class="f_req">*</span></label>
                    <select name="laptop_type" class="form-control">
                        <option value="new" <?php echo e($laptop->laptop_type == 'new' ? 'selected' : ''); ?>>New</option>
                        <option value="old" <?php echo e($laptop->laptop_type == 'old' ? 'selected' : ''); ?>>Old</option>
                        <option value="personal" <?php echo e($laptop->laptop_type == 'personal' ? 'selected' : ''); ?>>Personal</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Company Name <span class="f_req">*</span></label>
                    <input name="company_name" class="form-control" type="text" value="<?php echo e($laptop->company_name); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Assign Date <span class="f_req">*</span></label>
                    <input name="assign_date" class="form-control" type="date" value="<?php echo e($laptop->assign_date); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="ram">RAM <span class="f_req">*</span></label>
                    <select id="ram" name="ram" class="form-control" required>
                        <option value="">Select RAM</option>
                        <option value="2GB" <?php echo e(old('ram', $laptop->ram) == '2GB' ? 'selected' : ''); ?>>2 GB</option>
                        <option value="4GB" <?php echo e(old('ram', $laptop->ram) == '4GB' ? 'selected' : ''); ?>>4 GB</option>
                        <option value="8GB" <?php echo e(old('ram', $laptop->ram) == '8GB' ? 'selected' : ''); ?>>8 GB</option>
                        <option value="16GB" <?php echo e(old('ram', $laptop->ram) == '16GB' ? 'selected' : ''); ?>>16 GB</option>
                        <option value="32GB" <?php echo e(old('ram', $laptop->ram) == '32GB' ? 'selected' : ''); ?>>32 GB</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="storage">Storage <span class="f_req">*</span></label>
                    <select id="storage" name="storage" class="form-control" required>
                        <option value="">Select Storage</option>
                        <option value="256GB" <?php echo e(old('storage', $laptop->storage) == '256GB' ? 'selected' : ''); ?>>256 GB SSD</option>
                        <option value="500GB" <?php echo e(old('storage', $laptop->storage) == '500GB' ? 'selected' : ''); ?>>500 GB SSD</option>
                        <option value="1TB" <?php echo e(old('storage', $laptop->storage) == '1TB' ? 'selected' : ''); ?>>1 TB SSD</option>
                        <option value="500GB_HDD" <?php echo e(old('storage', $laptop->storage) == '500GB_HDD' ? 'selected' : ''); ?>>500 GB HDD</option>
                        <option value="1TB_HDD" <?php echo e(old('storage', $laptop->storage) == '1TB_HDD' ? 'selected' : ''); ?>>1 TB HDD</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Microsoft Account</label>
                    <input name="microsoft_account" class="form-control" type="text" value="<?php echo e($laptop->microsoft_account); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Password</label>
                    <input name="password" class="form-control" type="password" value="<?php echo e($laptop->password); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Recovery Code</label>
                    <input name="recovery_code" class="form-control" type="text" value="<?php echo e($laptop->recovery_code); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Host Info</label>
                    <textarea name="host_info" class="form-control" rows="3"><?php echo e($laptop->host_info); ?></textarea>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button class="btn btn-primary" type="submit">Update Laptop</button>
            <a href="<?php echo e(route('laptop_tracker.index')); ?>" class="btn btn-default">Cancel</a>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/edit.blade.php ENDPATH**/ ?>