

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">List of Laptops</h3>

    <?php if(session('success')): ?>
    <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div id="response-message" class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <table class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>Serial Number</th>
                <th>Model Name</th>
                <th>Company Name</th>
                <th>RAM</th>
                <th>Storage</th>
                <th>SSD/HDD</th>
                <th>Processor</th>
                <th>Generation</th>
                <th>Purchase Date</th>
                <th>Purchase Amount</th>
                <th>Warranty Status</th>
                <th>Warranty Expiry Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $laptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($laptop->serial_number); ?></td>
                <td><?php echo e($laptop->model_name); ?></td>
                <td><?php echo e($laptop->company_name); ?></td>
                <td><?php echo e($laptop->ram); ?></td>
                <td><?php echo e($laptop->storage); ?></td>
                <td><?php echo e(ucfirst($laptop->ssd_hdd)); ?></td>
                <td><?php echo e($laptop->processor); ?></td>
                <td><?php echo e($laptop->generation); ?></td>
                <td><?php echo e($laptop->purchase_date ? \Carbon\Carbon::parse($laptop->purchase_date)->format('Y-m-d') : 'N/A'); ?></td>
                <td><?php echo e($laptop->purchase_amount ? '₹' . number_format($laptop->purchase_amount, 2) : 'N/A'); ?></td>
                <td><?php echo e(ucfirst($laptop->warranty_status)); ?></td>
                <td><?php echo e($laptop->warranty_expiry_date ? \Carbon\Carbon::parse($laptop->warranty_expiry_date)->format('Y-m-d') : 'N/A'); ?></td>
                <td>
                    <!-- View Button with 'eye' icon -->
                    <a href="<?php echo e(route('new_laptops.show', $laptop->id)); ?>" class="btn btn-info">
                        <span class="fa fa-eye"></span>  
                    </a>
                
                    <!-- Edit Button with 'pencil' icon -->
                    <a href="<?php echo e(route('new_laptops.edit', $laptop->id)); ?>" class="btn btn-warning">
                        <span class="fa fa-pencil"></span>  
                    </a>
                
                    <!-- Delete Button with 'trash' icon -->
                    <form action="<?php echo e(route('new_laptops.destroy', $laptop->id)); ?>" method="POST" style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-danger" type="submit" onclick="return confirm('Are you sure you want to delete this laptop?')">
                            <span class="fa fa-trash"></span>  
                        </button>
                    </form>
                </td>
                
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <a href="<?php echo e(route('new_laptops.create')); ?>" class="btn btn-primary">Add New Laptop</a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/software.madalasahospital.com/resources/views/pages/laptop_tracker/new_laptops/index.blade.php ENDPATH**/ ?>