

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Employees Without Laptop</h3>

    <div class="mb-3">
        <a href="<?php echo e(route('employees.create')); ?>" class="btn btn-primary">Add New Employee</a>
        <a href="#" class="btn btn-success">Total Employees Without Laptop: <?php echo e($empCount); ?></a>
    </div>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Name</th>
                <th>Department</th>
                <th>Phone</th>
                <th>Emergency Contact</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($employee->name); ?></td>
                <td><?php echo e($employee->department); ?></td>
                <td><?php echo e($employee->phone); ?></td>
                <td><?php echo e($employee->emergency_contact); ?></td>
                <td>
                    <a href="<?php echo e(route('employees.edit', $employee->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                    <form action="<?php echo e(route('employees.destroy', $employee->id)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this employee?')">Delete</button>
                    </form>
                    <a href="<?php echo e(route('laptop_tracker.create', ['employee_id' => $employee->id])); ?>">
                        <button class="btn btn-secondary btn-sm">
                            <i class="fas fa-exchange-alt"></i> Assign
                        </button>
                    </a>
                    
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <!-- Pagination Links -->
    <div class="d-flex justify-content-center">
        <?php echo e($employees->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/software.madalasahospital.com/resources/views/pages/laptop_tracker/employee/without_laptop.blade.php ENDPATH**/ ?>