

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12">
    <h3 class="heading">Add Camp Details</h3>
    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
    <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php elseif(session('error')): ?>
    <div id="response-message" class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <form id="campForm" class="form_validation_reg" action="<?php echo e(route('camp.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="formSep">
            <div class="row">
                <div class="col-sm-2 col-md-2">
                    <label>Camp Location <span class="f_req">*</span></label>
                    <input name="camp_location" class="form-control" type="text" value="<?php echo e(old('camp_location', session('last_camp_location', ''))); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Camp Date <span class="f_req">*</span></label>
                    <input name="camp_date" class="form-control" type="date" value="<?php echo e(old('camp_date', session('last_camp_date', ''))); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Pt Name <span class="f_req">*</span></label>
                    <input name="pt_name" class="form-control" type="text" value="<?php echo e(old('pt_name')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Phone <span class="f_req">*</span></label>
                    <input name="phone" class="form-control" type="text" value="<?php echo e(old('phone')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="feedback-status">Phone Status <span class="f_req">*</span></label>

                <select name="phone_status" id="phone-status" class="form-control">

                    <option value="">-select-</option>
                    <option value="Connected" <?php echo e(old('phone_status') == 'Connected' ? 'selected' : ''); ?>>Connected</option>
                    <option value="Phone Cut" <?php echo e(old('phone_status') == 'Phone Cut' ? 'selected' : ''); ?>>Phone Cut</option>
                    <option value="Switched Off" <?php echo e(old('phone_status') == 'Switched Off' ? 'selected' : ''); ?>>Phone Switched Off</option>
                    <option value="Out of Reach" <?php echo e(old('phone_status') == 'Out of Reach' ? 'selected' : ''); ?>>Out of Reach</option>
                    <option value="Not Picking" <?php echo e(old('phone_status') == 'Not Picking' ? 'selected' : ''); ?>>Not Picking Up</option>
                    <option value="Busy" <?php echo e(old('phone_status') == 'Busy' ? 'selected' : ''); ?>>Busy</option>
                    <option value="No Answer" <?php echo e(old('phone_status') == 'No Answer' ? 'selected' : ''); ?>>No Answer</option>
                    <option value="Call Dropped" <?php echo e(old('phone_status') == 'Call Dropped' ? 'selected' : ''); ?>>Call Dropped</option>
                    <option value="Voicemail" <?php echo e(old('phone_status') == 'Voicemail' ? 'selected' : ''); ?>>Voicemail</option>
                    <option value="Number Not in Service" <?php echo e(old('phone_status') == 'Number Not in Service' ? 'selected' : ''); ?>>Number Not in Service</option>
                </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Age</label>
                    <input name="age" class="form-control" type="number" value="<?php echo e(old('age')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Gender</label>
                    <label class="radio-inline">
                        <input value="Male" name="gender" type="radio" <?php echo e(old('gender') == 'Male' ? 'checked' : ''); ?>>
                        Male
                    </label>
                    <label class="radio-inline">
                        <input value="Female" name="gender" type="radio" <?php echo e(old('gender') == 'Female' ? 'checked' : ''); ?>>
                        Female
                    </label>
                </div>
                
                <div class="col-sm-2 col-md-2">
                    <label>B.P (mm/hg)</label>
                    <input name="bp" class="form-control" type="text" value="<?php echo e(old('bp')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>RBS (mg/dl)</label>
                    <input name="rbs" class="form-control" type="text" value="<?php echo e(old('rbs')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="feedback-status">Dr. Consultation <span class="f_req">*</span></label>
                    <select name="feedback_status" id="feedback-status" class="form-control">
                        <option value="">-select-</option>
                        <option value="Yes" <?php echo e(old('feedback_status') == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e(old('feedback_status') == 'No' ? 'selected' : ''); ?>>No</option>
                
                    </select>
                </div>
            </div>
        </div>
        
        <div class="formSep">
            <label>Remark</label>
            <textarea name="remark" id="remark" cols="10" rows="3" class="form-control"><?php echo e(old('remark')); ?></textarea>
        </div>
        
        <div class="form-actions">
            <button class="btn btn-primary" type="submit">Save & Add Next</button>
            <button class="btn btn-default" type="reset">Cancel</button>
            <a href="<?php echo e(route('camp.index')); ?>" class="btn btn-info">View All Camps</a>

        </div>
    </form>
    <div id="response-message" class="alert" style="display:none;"></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/software.madalasahospital.com/resources/views/pages/office/camp/create.blade.php ENDPATH**/ ?>