

<?php $__env->startSection('content'); ?> <br><br><br>
     <!-- Search and Device Count Overview -->
    <div class="row">
        <div class="col-md-3">
            <form action="<?php echo e(route('devices.department', $department)); ?>" method="GET" class="form-inline mb-3">
                <input type="text" name="search" class="form-control mr-2"
                    placeholder="Search by Serial No or Employee Name" value="<?php echo e(request('search')); ?>">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Total Devices:</strong> <?php echo e($devices->total()); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2 text-center">
                        <strong>Total Laptops:</strong> <?php echo e($totalLaptops); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2 text-center">
                        <strong>Total Desktops:</strong> <?php echo e($totalDesktops); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Department:</strong> <?php echo e($department); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Devices Table -->
    <?php if($devices->count() > 0): ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Device Type</th>
                <th>Assign Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($device->employee ? $device->employee->name : 'Unassigned'); ?></td>
                    <td><?php echo e($device->serial_number); ?></td>
                    <td><?php echo e(ucfirst($device->device_type)); ?></td>
                    <td><?php echo e($device->assign_date ? \Carbon\Carbon::parse($device->assign_date)->format('Y-m-d') : 'N/A'); ?></td>
                    <td>
                        <!-- Action buttons -->
                        <a href="<?php echo e(route('laptop_tracker.edit', $device->id)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                            data-target="#deleteModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button class="btn btn-info btn-sm" data-toggle="modal"
                            data-target="#viewModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button class="btn btn-secondary btn-sm" data-toggle="modal"
                            data-target="#reassignModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-exchange-alt"></i> Reassign
                        </button>
                        <button class="btn btn-dark btn-sm" data-toggle="modal"
                            data-target="#historyModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-history"></i> History
                        </button>
                        <button class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#addAccessoryModal-<?php echo e($device->id); ?>">
                        <i class="fas fa-plus"></i> Add Accessory
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                    data-target="#viewAccessoryModal-<?php echo e($device->id); ?>">
                    <i class="fas fa-eye"></i> View Accessories
                </button>
                        <button class="btn btn-primary btn-sm" data-toggle="modal"
                            data-target="#repairModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-tools"></i> Repair
                        </button>
                        <button class="btn btn-info btn-sm" data-toggle="modal"
                            data-target="#repairHistoryModal-<?php echo e($device->id); ?>">
                            <i class="fas fa-history"></i> Repair History
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($devices->links()); ?> <!-- Pagination links -->

    <?php else: ?>
    <p>No devices found in the <?php echo e($department); ?> department.</p>
    <?php endif; ?>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/department_devices.blade.php ENDPATH**/ ?>