<!-- View Accessories Modal -->
<?php $__currentLoopData = $laptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="viewAccessoryModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog"
        aria-labelledby="viewAccessoryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewAccessoryModalLabel">Accessories for Laptop: <?php echo e($laptop->serial_number); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php if($laptop->accessories->isEmpty()): ?>
                        <p>No accessories found for this laptop.</p>
                    <?php else: ?>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Accessory Name</th>
                                    <th>Price</th>
                                    <th>Approved By</th>
                                    <th>Bill</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $laptop->accessories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accessory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($accessory->name); ?></td>
                                        <td><?php echo e($accessory->price); ?></td>
                                        <td><?php echo e($accessory->approved_by ?? 'N/A'); ?></td>
                                        <td>
                                            <?php if($accessory->bill_file): ?>
                                                <a href="<?php echo e(Storage::url($accessory->bill_file)); ?>" target="_blank" class="btn btn-info btn-sm">
                                                    <i class="fa fa-eye"></i> View Bill
                                                </a>
                                                <a href="<?php echo e(route('accessories.download', $accessory->id)); ?>" class="btn btn-success btn-sm">
                                                    <i class="fa fa-download"></i> Download Bill
                                                </a>
                                                <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editAccessoryModal-<?php echo e($accessory->id); ?>">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteAccessoryModal-<?php echo e($accessory->id); ?>">
                                                    <i class="fas fa-trash-alt"></i> Delete
                                                </button>
                                            <?php else: ?>
                                                No bill uploaded
                                            <?php endif; ?>
                                           
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH /home2/madalozy/software.madalasahospital.com/resources/views/pages/laptop_tracker/accessories/viewModel.blade.php ENDPATH**/ ?>