@extends('layouts.master')

@section('content') <br><br><br>
<div class="col-sm-12 col-md-12">

     
    <div class="row">
        <div class="col-sm-12 col-md-12">
            <h5 class="heading">
                <a href="{{ route('camp.create') }}" class="btn btn-primary mb-3">Add New Camp</a> <br> <hr>
                <span style="box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;color:#004f6f;">
                Connected: {{ $totalConnected }},
                Phone Cut: {{ $totalPhoneCut }},
                Switched Off: {{ $totalSwitchedOff }},
                Out of Reach: {{ $totalOutOfReach }},
                Not Picking: {{ $totalNotPicking }},
                Busy: {{ $totalBusy }},
                No Answer: {{ $totalNoAnswer }},
                Call Dropped: {{ $totalCallDropped }},
                Voicemail: {{ $totalVoicemail }},
                Number Not in Service: {{ $totalNotInService }}
            </span>
            </h5>
            
            @if (session('success'))
                <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
            @elseif(session('error'))
                <div id="response-message" class="alert alert-danger">{{ session('error') }}</div>
            @endif

            <form method="GET" action="{{ route('camp.index') }}" class="form-inline mb-3">
                <div class="form-group">
                    <label for="phone">Phone:</label>
                    <input type="text" name="phone" id="phone" class="form-control mx-2" value="{{ request('phone') }}">
                </div>
                <div class="form-group">
                    <label for="pt_name">Patient Name:</label>
                    <input type="text" name="pt_name" id="pt_name" class="form-control mx-2" value="{{ request('pt_name') }}">
                </div>
                <div class="form-group">
                    <label for="from_date">From Date:</label>
                    <input type="date" name="from_date" id="from_date" class="form-control mx-2" value="{{ request('from_date') }}">
                </div>
                <div class="form-group">
                    <label for="to_date">To Date:</label>
                    <input type="date" name="to_date" id="to_date" class="form-control mx-2" value="{{ request('to_date') }}">
                </div>
                <div class="form-group">
                    <label for="phone_status">Phone Status:</label>
                    <select name="phone_status" id="phone_status" class="form-control mx-2">
                        <option value="">-select-</option>
                        <option value="Connected" {{ request('phone_status') == 'Connected' ? 'selected' : '' }}>Connected</option>
                        <option value="Switched Off" {{ request('phone_status') == 'Switched Off' ? 'selected' : '' }}>Phone Switched Off</option>
                        <option value="Out of Reach" {{ request('phone_status') == 'Out of Reach' ? 'selected' : '' }}>Out of Reach</option>
                        <option value="Not Picking" {{ request('phone_status') == 'Not Picking' ? 'selected' : '' }}>Not Picking Up</option>
                        <option value="Busy" {{ request('phone_status') == 'Busy' ? 'selected' : '' }}>Busy</option>
                        <option value="No Answer" {{ request('phone_status') == 'No Answer' ? 'selected' : '' }}>No Answer</option>
                        <option value="Call Dropped" {{ request('phone_status') == 'Call Dropped' ? 'selected' : '' }}>Call Dropped</option>
                        <option value="Voicemail" {{ request('phone_status') == 'Voicemail' ? 'selected' : '' }}>Voicemail</option>
                        <option value="Number Not in Service" {{ request('phone_status') == 'Number Not in Service' ? 'selected' : '' }}>Number Not in Service</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-info">Filter</button>
                <a href="{{ route('camp.index') }}" class="btn btn-secondary ml-2">Reset</a>
            </form>

            <table class="table table-striped table-bordered dTableR" id="dt_a">
                <thead>
                    <tr>
                        <th>Camp Location</th>
                        <th>Camp Date</th>
                        <th>Pt Name</th>
                        <th>Phone</th>
                        <th>Phone Status</th>
                        <th>Status</th>
                        <th>Remark</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($camps as $camp)
                        <tr
                            class="
                            {{ $camp->phone_status == 'Connected' ? 'phone-status-connected' : '' }}
                            {{ $camp->phone_status == 'Switched Off' ? 'phone-status-switched-off' : '' }}
                            {{ $camp->phone_status == 'Out of Reach' ? 'phone-status-out-of-reach' : '' }}
                            {{ $camp->phone_status == 'Not Picking' ? 'phone-status-not-picking' : '' }}
                            {{ $camp->phone_status == 'Busy' ? 'phone-status-busy' : '' }}
                            {{ $camp->phone_status == 'No Answer' ? 'phone-status-no-answer' : '' }}
                            {{ $camp->phone_status == 'Call Dropped' ? 'phone-status-call-dropped' : '' }}
                            {{ $camp->phone_status == 'Voicemail' ? 'phone-status-voicemail' : '' }}
                            {{ $camp->phone_status == 'Number Not in Service' ? 'phone-status-not-in-service' : '' }}
                        ">
                            <td>{{ $camp->camp_location }}</td>
                            <td>{{ $camp->camp_date }}</td>
                            <td>{{ $camp->pt_name }}</td>
                            <td>{{ $camp->phone }}</td>
                            <td>{{ $camp->phone_status }}</td>
                            <td>{{ $camp->feedback_status }}</td>
                            <td>{{ Str::limit($camp->remark, 30) }}</td>
                            <td>
                                <!-- View Button with Icon Only -->
                                <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewModal{{ $camp->id }}">
                                    <i class="fas fa-eye"></i>
                                </button>
                                
                                <!-- Edit Button -->
                                <a href="{{ route('camp.edit', $camp->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                
                                <!-- Delete Button -->
                                <form action="{{ route('camp.destroy', $camp->id) }}" method="POST"
                                    style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm"
                                        onclick="return confirm('Are you sure you want to delete this record?')">Delete</button>
                                </form>
                                
                                <!-- Share Button with Icon Only -->
                                <a href="https://api.whatsapp.com/send?phone=918630293886&text=Patient%20Name:%20{{ urlencode($camp->pt_name) }}%0APhone:%20{{ urlencode($camp->phone) }}%0ARemark:%20{{ urlencode($camp->remark) }}" target="_blank" class="btn btn-success btn-sm">
                                    <i class="fas fa-share"></i>
                                </a>
                            </td>
                        </tr>

                        <!-- View Modal -->
                        <div class="modal fade" id="viewModal{{ $camp->id }}" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel{{ $camp->id }}" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="viewModalLabel{{ $camp->id }}">Camp Details</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <p><strong>Camp Location:</strong> {{ $camp->camp_location }}</p>
                                        <p><strong>Camp Date:</strong> {{ $camp->camp_date }}</p>
                                        <p><strong>Patient Name:</strong> {{ $camp->pt_name }}</p>
                                        <p><strong>Phone:</strong> {{ $camp->phone }}</p>
                                        <p><strong>Phone Status:</strong> {{ $camp->phone_status }}</p>
                                        <p><strong>Status:</strong> {{ $camp->feedback_status }}</p>
                                        <p><strong>Remark:</strong> {{ $camp->remark }}</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>

           <!-- Pagination -->
           <div class="d-flex justify-content-center">
            {{ $camps->links() }}
        </div>
        </div>
    </div>

</div>
@endsection
