@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Laptop Repairs</h3>

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Laptop Serial Number</th>
                <th>Repair Details</th>
                <th>Repaired By</th>
                <th>Cost</th>
                <th>Repair Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($repairs as $repair)
            <tr>
                <td>{{ $repair->laptop->serial_number }}</td>
                <td>{{ Str::limit($repair->repair_details, 30) }}</td>
                <td>{{ $repair->repaired_by }}</td>
                <td>{{ $repair->cost }}</td>
                <td>{{ $repair->repair_date->format('Y-m-d') }}</td>
                <td>
                    <a href="{{ route('repairs.show', $repair->id) }}" class="btn btn-info btn-sm">
                        <i class="fas fa-eye"></i>
                    </a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $repairs->links() }}
</div>
@endsection
