@foreach ($laptops as $laptop)
    @foreach ($laptop->repairs as $repair)
        <div class="modal fade" id="editRepairModal-{{ $repair->id }}" tabindex="-1" role="dialog"
            aria-labelledby="editRepairModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editRepairModalLabel">Edit Repair for Laptop - {{ $laptop->serial_number }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('repairs.update', $repair->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="repair_details">Repair Details</label>
                                <textarea id="repair_details" name="repair_details" class="form-control" rows="3" required>{{ $repair->repair_details }}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="repaired_by">Repaired By</label>
                                <input type="text" id="repaired_by" name="repaired_by" class="form-control" value="{{ $repair->repaired_by }}" required>
                            </div>
                            <div class="form-group">
                                <label for="cost">Repair Cost</label>
                                <input type="number" id="cost" name="cost" class="form-control" step="0.01" value="{{ $repair->cost }}" required>
                            </div>
                            <div class="form-group">
                                <label for="approved_by">Approved By</label>
                                <input type="text" id="approved_by" name="approved_by" class="form-control" value="{{ $repair->approved_by }}" required>
                            </div>
                            <div class="form-group">
                                <label for="bill">Upload New Bill (Optional)</label>
                                <input type="file" id="bill" name="bill" class="form-control-file">
                            </div>
                            @if ($repair->bill)
                                <p>Current Bill: <a href="{{ Storage::url($repair->bill) }}" target="_blank">View Bill</a></p>
                            @endif
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update Repair</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endforeach
