@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Edit Laptop Details</h3>

    @if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form id="editLaptopForm" class="form_validation_reg" action="{{ route('new_laptops.update', $laptop->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="formSep">
            <div class="row">
                <!-- Serial Number -->
                <div class="col-sm-2 col-md-2">
                    <label for="serial_number">Serial Number <span class="f_req">*</span></label>
                    <input id="serial_number" name="serial_number" class="form-control" type="text" value="{{ old('serial_number', $laptop->serial_number) }}" required>
                </div>

                <!-- Laptop Type -->
                <div class="col-sm-2 col-md-2">
                    <label for="laptop_type">Laptop Type <span class="f_req">*</span></label>
                    <select id="laptop_type" name="laptop_type" class="form-control" required>
                        <option value="">Select Type</option>
                        <option value="new" {{ old('laptop_type', $laptop->laptop_type) == 'new' ? 'selected' : '' }}>New</option>
                        <option value="old" {{ old('laptop_type', $laptop->laptop_type) == 'old' ? 'selected' : '' }}>Old</option>
                        <option value="personal" {{ old('laptop_type', $laptop->laptop_type) == 'personal' ? 'selected' : '' }}>Personal</option>
                    </select>
                </div>

                <!-- Model Name -->
                <div class="col-sm-2 col-md-2">
                    <label for="model_name">Model Name</label>
                    <input id="model_name" name="model_name" class="form-control" type="text" value="{{ old('model_name', $laptop->model_name) }}">
                </div>

                <!-- Company Name -->
                <div class="col-sm-2 col-md-2">
                    <label for="company_name">Company Name <span class="f_req">*</span></label>
                    <input id="company_name" name="company_name" class="form-control" type="text" value="{{ old('company_name', $laptop->company_name) }}" required>
                </div>

                <!-- RAM -->
                <div class="col-sm-2 col-md-2">
                    <label for="ram">RAM</label>
                    <select id="ram" name="ram" class="form-control" required>
                        <option value="">Select RAM</option>
                        <option value="2GB" {{ old('ram', $laptop->ram) == '2GB' ? 'selected' : '' }}>2 GB</option>
                        <option value="4GB" {{ old('ram', $laptop->ram) == '4GB' ? 'selected' : '' }}>4 GB</option>
                        <option value="8GB" {{ old('ram', $laptop->ram) == '8GB' ? 'selected' : '' }}>8 GB</option>
                        <option value="16GB" {{ old('ram', $laptop->ram) == '16GB' ? 'selected' : '' }}>16 GB</option>
                        <option value="32GB" {{ old('ram', $laptop->ram) == '32GB' ? 'selected' : '' }}>32 GB</option>
                    </select>
                </div>

                <!-- Storage -->
                <div class="col-sm-2 col-md-2">
                    <label for="storage">Storage</label>
                    <select id="storage" name="storage" class="form-control" required>
                        <option value="">Select Storage</option>
                        <option value="256GB" {{ old('storage', $laptop->storage) == '256GB' ? 'selected' : '' }}>256 GB SSD</option>
                        <option value="500GB" {{ old('storage', $laptop->storage) == '500GB' ? 'selected' : '' }}>500 GB SSD</option>
                        <option value="1TB" {{ old('storage', $laptop->storage) == '1TB' ? 'selected' : '' }}>1 TB SSD</option>
                        <option value="500GB_HDD" {{ old('storage', $laptop->storage) == '500GB_HDD' ? 'selected' : '' }}>500 GB HDD</option>
                        <option value="1TB_HDD" {{ old('storage', $laptop->storage) == '1TB_HDD' ? 'selected' : '' }}>1 TB HDD</option>
                    </select>
                </div>

                <!-- SSD/HDD -->
                <div class="col-sm-2 col-md-2">
                    <label for="ssd_hdd">SSD/HDD</label>
                    <select id="ssd_hdd" name="ssd_hdd" class="form-control">
                        <option value="">Select Type</option>
                        <option value="ssd" {{ old('ssd_hdd', $laptop->ssd_hdd) == 'ssd' ? 'selected' : '' }}>SSD</option>
                        <option value="hdd" {{ old('ssd_hdd', $laptop->ssd_hdd) == 'hdd' ? 'selected' : '' }}>HDD</option>
                    </select>
                </div>

                <!-- Processor -->
                <div class="col-sm-2 col-md-2">
                    <label for="processor">Processor</label>
                    <input id="processor" name="processor" class="form-control" type="text" value="{{ old('processor', $laptop->processor) }}">
                </div>

                <!-- Generation -->
                <div class="col-sm-2 col-md-2">
                    <label for="generation">Generation</label>
                    <input id="generation" name="generation" class="form-control" type="text" value="{{ old('generation', $laptop->generation) }}">
                </div>

                <!-- Purchase Date -->
                <div class="col-sm-2 col-md-2">
                    <label for="purchase_date">Purchase Date</label>
                    <input id="purchase_date" name="purchase_date" class="form-control" type="date" value="{{ old('purchase_date', $laptop->purchase_date) }}">
                </div>

                <!-- Purchase Amount -->
                <div class="col-sm-2 col-md-2">
                    <label for="purchase_amount">Purchase Amount</label>
                    <input id="purchase_amount" name="purchase_amount" class="form-control" type="text" value="{{ old('purchase_amount', $laptop->purchase_amount) }}">
                </div>

                <!-- Purchase Bill -->
                <div class="col-sm-2 col-md-2">
                    <label for="purchase_bill">Purchase Bill</label>
                    <input id="purchase_bill" name="purchase_bill" class="form-control" type="file">
                </div>

                <!-- Supplier Name -->
                <div class="col-sm-2 col-md-2">
                    <label for="supplier_name">Supplier Name</label>
                    <input id="supplier_name" name="supplier_name" class="form-control" type="text" value="{{ old('supplier_name', $laptop->supplier_name) }}">
                </div>

                <!-- Warranty Status -->
                <div class="col-sm-2 col-md-2">
                    <label for="warranty_status">Warranty Status</label>
                    <input id="warranty_status" name="warranty_status" class="form-control" type="text" value="{{ old('warranty_status', $laptop->warranty_status) }}">
                </div>

                <!-- Warranty Expiry Date -->
                <div class="col-sm-2 col-md-2">
                    <label for="warranty_expiry_date">Warranty Expiry Date</label>
                    <input id="warranty_expiry_date" name="warranty_expiry_date" class="form-control" type="date" value="{{ old('warranty_expiry_date', $laptop->warranty_expiry_date) }}">
                </div>

                <!-- Asset Tag -->
                <div class="col-sm-2 col-md-2">
                    <label for="asset_tag">Asset Tag</label>
                    <input id="asset_tag" name="asset_tag" class="form-control" type="text" value="{{ old('asset_tag', $laptop->asset_tag) }}">
                </div>

                <!-- Notes -->
                <div class="col-sm-12 col-md-12">
                    <label for="notes">Notes</label>
                    <textarea id="notes" name="notes" class="form-control" rows="3">{{ old('notes', $laptop->notes) }}</textarea>
                </div>
            </div>
        </div>

        <div class="formSep">
            <button type="submit" class="btn btn-info">Update Laptop</button>
        </div>
    </form>
</div>
@endsection
