@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Employees Without Laptop</h3>

    <div class="mb-3">
        <a href="{{ route('employees.create') }}" class="btn btn-primary">Add New Employee</a>
        <a href="#" class="btn btn-success">Total Employees Without Laptop: {{ $empCount }}</a>
    </div>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Name</th>
                <th>Department</th>
                <th>Phone</th>
                <th>Emergency Contact</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($employees as $employee)
            <tr>
                <td>{{ $employee->name }}</td>
                <td>{{ $employee->department }}</td>
                <td>{{ $employee->phone }}</td>
                <td>{{ $employee->emergency_contact }}</td>
                <td>
                    <a href="{{ route('employees.edit', $employee->id) }}" class="btn btn-warning btn-sm">Edit</a>
                    <form action="{{ route('employees.destroy', $employee->id) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this employee?')">Delete</button>
                    </form>
                    <a href="{{ route('laptop_tracker.create', ['employee_id' => $employee->id]) }}">
                        <button class="btn btn-secondary btn-sm">
                            <i class="fas fa-exchange-alt"></i> Assign
                        </button>
                    </a>
                    
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Pagination Links -->
    <div class="d-flex justify-content-center">
        {{ $employees->links() }}
    </div>
</div>
@endsection
