@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Add Employee Details</h3>

    @if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @elseif(session('error'))
    <div id="response-message" class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <form id="employeeForm" class="form_validation_reg" action="{{ route('employees.store') }}" method="POST">
        @csrf
        <div class="formSep">
            <div class="row">
                <div class="col-sm-2 col-md-2">
                    <label>Employee Name <span class="f_req">*</span></label>
                    <input name="name" class="form-control" type="text" value="{{ old('name') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="department">Department <span class="f_req">*</span></label>
                    <select id="department" name="department" class="form-control" required>
                        <option value="">Select Department</option>
                        <option value="Internal Auditor">Internal Auditor</option>
                        <option value="Madalasa Hospital">Madalasa Hospital</option>
                        <option value="Gole Market">Gole Market</option>
                        <option value="sdpskb Shool">sdpskb Shool</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Employee Phone No <span class="f_req">*</span></label>
                    <input name="phone" class="form-control" type="text" value="{{ old('phone') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Emergency Phone No</label>
                    <input name="emergency_contact" class="form-control" type="text" value="{{ old('emergency_contact') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Email Address <span class="f_req">*</span></label>
                    <input name="email" class="form-control" type="email" value="{{ old('email') }}">
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button class="btn btn-primary" type="submit">Save Employee</button>
            <button class="btn btn-default" type="reset">Cancel</button>
            <a href="{{ route('employees.index') }}" class="btn btn-info">View All Employees</a>
        </div>
    </form>
    <div id="response-message" class="alert" style="display:none;"></div>
</div>
@endsection
