@extends('layouts.master')

@section('content')
<div class="container-fluid">
    <h3 class="heading text-center mb-4">Desktop</h3>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Company Name</th>
                <th>Assign Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($laptops as $laptop)
                <tr>
                    <td>{{ $laptop->employee ? $laptop->employee->name : 'Unassigned' }}</td>
                    <td>{{ $laptop->serial_number }}</td>
                    <td>{{ $laptop->company_name }}</td>
                    <td>{{ $laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $laptops->links() }} <!-- Pagination -->
</div>
@endsection
