@foreach ($laptops as $laptop)
    @foreach ($laptop->accessories as $accessory)
        <div class="modal fade" id="editAccessoryModal-{{ $accessory->id }}" tabindex="-1" role="dialog"
            aria-labelledby="editAccessoryModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editAccessoryModalLabel">Edit Accessory: {{ $accessory->name }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('accessories.update', $accessory->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="name">Accessory Name</label>
                                <input type="text" name="name" class="form-control" value="{{ $accessory->name }}" required>
                            </div>
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input type="number" name="price" class="form-control" value="{{ $accessory->price }}" step="0.01" required>
                            </div>
                            <div class="form-group">
                                <label for="approved_by">Approved By</label>
                                <input type="text" name="approved_by" class="form-control" value="{{ $accessory->approved_by }}">
                            </div>
                            <div class="form-group">
                                <label for="bill_file">Upload New Bill (optional)</label>
                                <input type="file" name="bill_file" class="form-control">
                            </div>
                            @if ($accessory->bill_file)
                                <p>Current Bill: <a href="{{ Storage::url($accessory->bill_file) }}" target="_blank">View Bill</a></p>
                            @endif
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update Accessory</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
@endforeach
