@foreach ($laptops as $laptop)
    @foreach ($laptop->accessories as $accessory)
        <div class="modal fade" id="deleteAccessoryModal-{{ $accessory->id }}" tabindex="-1" role="dialog"
            aria-labelledby="deleteAccessoryModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteAccessoryModalLabel">Delete Accessory: {{ $accessory->name }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this accessory?
                    </div>
                    <div class="modal-footer">
                        <form action="{{ route('accessories.destroy', $accessory->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endforeach
