<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('new_laptops', function (Blueprint $table) {
            $table->id();
            $table->string('serial_number')->unique(); // Unique serial number for each laptop
            $table->string('laptop_type');  // New, old, personal, etc.
            $table->string('company_name'); // Brand or company of the laptop
            $table->string('model_name')->nullable(); // Model name of the laptop
            $table->string('ram')->nullable(); // RAM (e.g., 8GB, 16GB)
            $table->string('storage')->nullable(); // Storage (e.g., 512GB, 1TB)
            $table->string('ssd_hdd')->nullable(); // SSD or HDD
            $table->string('processor')->nullable(); // Processor type (e.g., i5, i7)
            $table->string('generation')->nullable(); // Processor generation (e.g., 10th, 11th)
            $table->date('purchase_date')->nullable(); // Purchase date of the laptop
            $table->decimal('purchase_amount', 10, 2)->nullable(); // Purchase price of the laptop
            $table->string('purchase_bill')->nullable(); // Path to uploaded purchase bill
            $table->string('supplier_name')->nullable(); // Name of the supplier
            $table->string('warranty_status')->nullable(); // Warranty status of the laptop (in warranty/out of warranty)
            $table->date('warranty_expiry_date')->nullable(); // Warranty expiry date
            $table->string('asset_tag')->nullable(); // Asset tag or tracking ID for internal use
            $table->text('notes')->nullable(); // Additional notes or details
            $table->timestamps(); // Standard created_at and updated_at timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('new_laptop_management', function (Blueprint $table) {
            //
        });
    }
};
