<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Laptop extends Model
{
    use HasFactory;

    protected $fillable = [
        'serial_number', 'laptop_type', 'company_name', 'assign_date',
        'microsoft_account', 'password', 'recovery_code', 
        'employee_id', 'is_personal', 'host_info','ram', 'storage','device_type'
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function history()
    {
        return $this->hasMany(LaptopHistory::class);
    }

    public function repairs()
    {
        return $this->hasMany(LaptopRepair::class);
    }

    public function accessories()
{
    return $this->hasMany(Accessory::class);
}

    
}
