<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Accessory extends Model
{
    use HasFactory;
    protected $fillable = [
        'laptop_id',
        'employee_id', // Update this
        'name',
        'price',
        'approved_by',
        'bill_file'
    ];

    public function laptop()
    {
        return $this->belongsTo(Laptop::class);
    }

    public function employee() // Update this method name
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
