<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;

class EmployeeController extends Controller
{
    public function index()
    {
        $employees = Employee::orderBy('id','desc')->paginate(10);
        $empCount = Employee::all();
        return view('pages.laptop_tracker.employee.index', compact('employees','empCount'));
    }


    public function create(){
     
        return view('pages.laptop_tracker.employee.create');
    }


    public function store(Request $request)
    {
        // Validate the incoming request
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'nullable|string|max:20',
            'emergency_contact' => 'nullable|string|max:20',
            'email' => 'nullable|string|email|max:255|unique:employees',
            'department' => 'required|string|max:255',
        ]);
         
        Employee::create([
            'name' => $request->name,
            'phone' => $request->phone,
            'emergency_contact' => $request->emergency_contact,
            'email' => $request->email,
            'department' => $request->department,
        ]);

        return redirect()->route('employees.index')->with('success', 'Employee added successfully.');
    }


    public function edit(Employee $employee)
    {
        return view('pages.laptop_tracker.employee.edit', compact('employee'));
    }

     public function update(Request $request, Employee $employee)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'nullable|string|max:20',
            'emergency_contact' => 'nullable|string|max:20',
            'email' => 'nullable|string|email|max:255|unique:employees,email,' . $employee->id,
            'department' => 'required|string|max:255',
        ]);

        $employee->update($request->all());

        return redirect()->route('employees.index')->with('success', 'Employee updated successfully.');
    }

    // Delete an employee from the database
    public function destroy(Employee $employee)
    {
        $employee->delete();

        return redirect()->route('employees.index')->with('success', 'Employee deleted successfully.');
    }



    public function employeesWithoutLaptop()
{
    // Fetch employees who do not have a laptop
    $employees = Employee::doesntHave('laptop')->paginate(10);
    $empCount = Employee::doesntHave('laptop')->count();

    return view('pages.laptop_tracker.employee.without_laptop', compact('employees', 'empCount'));
}

}
