<?php

namespace App\Http\Controllers;

use App\Models\Laptop; // Assuming Laptop model is used for devices
use Illuminate\Http\Request;
use App\Models\Employee;

class DeviceController extends Controller
{
    

    public function laptops(Request $request)
{
    $search = $request->get('search');
    
    // Only filter laptops
    $query = Laptop::where('device_type', 'laptop'); // Ensure that only laptops are selected

    if ($search) {
        $query->where('serial_number', 'like', "%{$search}%")
              ->orWhereHas('employee', function ($q) use ($search) {
                  $q->where('name', 'like', "%{$search}%");
              });
    }

    $laptops = $query->paginate(10);

    // Pass counts
    $totalLaptops = Laptop::where('device_type', 'laptop')->count();
    $totalDellLaptops = Laptop::where('device_type', 'laptop')->where('company_name', 'Dell')->count();
    $totalLenovoLaptops = Laptop::where('device_type', 'laptop')->where('company_name', 'Lenovo')->count();
    $employeesWithoutLaptop = Employee::doesntHave('laptop')->count();

    // Fetch all employees for modal (reassign feature)
    $employees = Employee::all();

    return view('pages.laptop_tracker.devices.laptops', compact('laptops', 'totalLaptops', 'totalDellLaptops', 'totalLenovoLaptops', 'employeesWithoutLaptop', 'employees'));
}

    
    public function desktops(Request $request)
    {
        $search = $request->get('search');
        $query = Laptop::where('device_type', 'desktop');

        if ($search) {
            $query->where('serial_number', 'like', "%{$search}%")
                  ->orWhereHas('employee', function ($q) use ($search) {
                      $q->where('name', 'like', "%{$search}%");
                  });
        }

        $desktops = $query->paginate(10);

        return view('pages.laptop_tracker.devices.desktops', compact('desktops'));
    }

    public function tablets(Request $request)
    {
        $search = $request->get('search');
        $query = Laptop::where('device_type', 'tablet');

        if ($search) {
            $query->where('serial_number', 'like', "%{$search}%")
                  ->orWhereHas('employee', function ($q) use ($search) {
                      $q->where('name', 'like', "%{$search}%");
                  });
        }

        $tablets = $query->paginate(10);

        return view('pages.laptop_tracker.devices.tablets', compact('tablets'));
    }

    public function mobiles(Request $request)
    {
        $search = $request->get('search');
        $query = Laptop::where('device_type', 'mobile');

        if ($search) {
            $query->where('serial_number', 'like', "%{$search}%")
                  ->orWhereHas('employee', function ($q) use ($search) {
                      $q->where('name', 'like', "%{$search}%");
                  });
        }

        $mobiles = $query->paginate(10);

        return view('pages.laptop_tracker.devices.mobiles', compact('mobiles'));
    }


  

}
