

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Active Laptops for <?php echo e($department); ?></h3>

    <form action="<?php echo e(route('laptop_tracker.index')); ?>" method="GET" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by Serial No or Employee Name" value="<?php echo e(request('search')); ?>">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>

    <?php if(session('success')): ?>
    <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Laptop Type</th>
                <th>Company Name</th>
                <th>Assign Date</th>
                <th>Microsoft Account</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $activeLaptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($laptop->employee ? $laptop->employee->name : 'Unassigned'); ?></td>
                <td><?php echo e($laptop->serial_number); ?></td>
                <td><?php echo e(ucfirst($laptop->laptop_type)); ?></td>
                <td><?php echo e($laptop->company_name); ?></td>
                <td><?php echo e($laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A'); ?></td>
                <td><?php echo e($laptop->microsoft_account); ?></td>
                <td>
                    <a href="<?php echo e(route('laptop_tracker.edit', $laptop->id)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i>
                    </a>
                    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-eye"></i>
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#reassignModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-exchange-alt"></i> Reassign
                    </button>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($activeLaptops->links()); ?> <!-- Pagination -->
</div>

<?php $__currentLoopData = $activeLaptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- View Modal -->
<div class="modal fade" id="viewModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">Laptop Details - <?php echo e($laptop->serial_number); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr><th>Serial Number</th><td><?php echo e($laptop->serial_number); ?></td></tr>
                    <tr><th>Laptop Type</th><td><?php echo e(ucfirst($laptop->laptop_type)); ?></td></tr>
                    <tr><th>Company Name</th><td><?php echo e($laptop->company_name); ?></td></tr>
                    <tr><th>Assign Date</th><td><?php echo e($laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A'); ?></td></tr>
                    <tr><th>Microsoft Account</th><td><?php echo e($laptop->microsoft_account); ?></td></tr>
                    <tr><th>Assigned To</th><td><?php echo e($laptop->employee ? $laptop->employee->name : 'Unassigned'); ?></td></tr>
                    <tr><th>Host Info</th><td><?php echo e($laptop->host_info); ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Reassign Modal -->
<div class="modal fade" id="reassignModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog" aria-labelledby="reassignModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reassignModalLabel">Reassign Laptop</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('laptop_tracker.reassign', $laptop->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Select New Employee</label>
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>">
                                    <?php echo e($employee->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="notes">Reassignment Notes</label>
                        <textarea id="notes" name="notes" class="form-control" rows="3"><?php echo e(old('notes')); ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Reassign</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/active_laptops.blade.php ENDPATH**/ ?>