

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Assign New Laptop</h3>

    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>

    <?php if(session('success')): ?>
    <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php elseif(session('error')): ?>
    <div id="response-message" class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <form id="laptopAssignForm" class="form_validation_reg" action="<?php echo e(route('laptop_tracker.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="formSep">
            <div class="row">
                <div class="col-sm-2 col-md-2">
                    <label for="employee_id">Select Employee <span class="f_req">*</span></label>
                    <div class="input-group">
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            <option value="">Select Employee</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>" 
                                    data-phone="<?php echo e($employee->phone); ?>" 
                                    data-emergency="<?php echo e($employee->emergency_contact); ?>"
                                    data-email="<?php echo e($employee->email); ?>"
                                    <?php echo e(isset($selectedEmployee) && $selectedEmployee->id == $employee->id ? 'selected' : ''); ?>>
                                    <?php echo e($employee->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="input-group-btn">
                            <button class="btn btn-secondary" type="button" data-toggle="modal" data-target="#employeeModal">
                                <i class="fas fa-search"></i>
                            </button>
                        </span>
                    </div>
                </div>

                <div class="col-sm-2 col-md-2">
                    <label for="phone">Employee Phone No</label>
                    <input id="phone" name="phone" class="form-control" type="text" 
                           value="<?php echo e(isset($selectedEmployee) ? $selectedEmployee->phone : ''); ?>" readonly>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="emergency_contact">Emergency Phone No</label>
                    <input id="emergency_contact" name="emergency_contact" class="form-control" type="text" 
                           value="<?php echo e(isset($selectedEmployee) ? $selectedEmployee->emergency_contact : ''); ?>" readonly>
                </div>

                <!-- Continue with other fields like serial number, laptop type, etc. -->
                <div class="col-sm-2 col-md-2">
                    <label for="serial_number">Serial Number <span class="f_req">*</span></label>
                    <input id="serial_number" name="serial_number" class="form-control" type="text" value="<?php echo e(old('serial_number')); ?>" required>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="device_type">Device Type <span class="f_req">*</span></label>
                    <select id="device_type" name="device_type" class="form-control" required>
                        <option value="">Select Device Type</option>
                        <option value="laptop" <?php echo e(old('device_type') == 'laptop' ? 'selected' : ''); ?>>Laptop</option>
                        <option value="desktop" <?php echo e(old('device_type') == 'desktop' ? 'selected' : ''); ?>>Desktop</option>
                        <option value="tablet" <?php echo e(old('device_type') == 'tablet' ? 'selected' : ''); ?>>Tablet</option>
                        <option value="phone" <?php echo e(old('device_type') == 'phone' ? 'selected' : ''); ?>>Phone</option>
                    </select>
                </div>
                
                
                <div class="col-sm-2 col-md-2">
                    <label for="laptop_type">Condition <span class="f_req">*</span></label>
                    <select id="laptop_type" name="laptop_type" class="form-control" required>
                        <option value="">Select Type</option>
                        <option value="new" <?php echo e(old('laptop_type') == 'new' ? 'selected' : ''); ?>>New</option>
                        <option value="old" <?php echo e(old('laptop_type') == 'old' ? 'selected' : ''); ?>>Old</option>
                        <option value="personal" <?php echo e(old('laptop_type') == 'personal' ? 'selected' : ''); ?>>Personal</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="company_name">Company Name <span class="f_req">*</span></label>
                    <input id="company_name" name="company_name" class="form-control" type="text" value="<?php echo e(old('company_name')); ?>" required>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="assign_date">Assign Date <span class="f_req">*</span></label>
                    <input id="assign_date" name="assign_date" class="form-control" type="date" value="<?php echo e(old('assign_date')); ?>" required>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="ram">RAM <span class="f_req">*</span></label>
                    <select id="ram" name="ram" class="form-control" required>
                        <option value="">Select RAM</option>
                        <option value="2GB" <?php echo e(old('ram') == '2GB' ? 'selected' : ''); ?>>2 GB</option>
                        <option value="4GB" <?php echo e(old('ram') == '4GB' ? 'selected' : ''); ?>>4 GB</option>
                        <option value="8GB" <?php echo e(old('ram') == '8GB' ? 'selected' : ''); ?>>8 GB</option>
                        <option value="16GB" <?php echo e(old('ram') == '16GB' ? 'selected' : ''); ?>>16 GB</option>
                        <option value="32GB" <?php echo e(old('ram') == '32GB' ? 'selected' : ''); ?>>32 GB</option>
                    </select>
                </div>
            
                <div class="col-sm-2 col-md-2">
                    <label for="storage">Storage <span class="f_req">*</span></label>
                    <select id="storage" name="storage" class="form-control" required>
                        <option value="">Select Storage</option>
                        <option value="256GB" <?php echo e(old('storage') == '256GB' ? 'selected' : ''); ?>>256 GB SSD</option>
                        <option value="500GB" <?php echo e(old('storage') == '500GB' ? 'selected' : ''); ?>>500 GB SSD</option>
                        <option value="1TB" <?php echo e(old('storage') == '1TB' ? 'selected' : ''); ?>>1 TB SSD</option>
                        <option value="500GB_HDD" <?php echo e(old('storage') == '500GB_HDD' ? 'selected' : ''); ?>>500 GB HDD</option>
                        <option value="1TB_HDD" <?php echo e(old('storage') == '1TB_HDD' ? 'selected' : ''); ?>>1 TB HDD</option>
                    </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="microsoft_account">Microsoft Account</label>
                    <input id="microsoft_account" name="microsoft_account" class="form-control" type="text" value="<?php echo e(old('microsoft_account')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="password">Password</label>
                    <input id="password" name="password" class="form-control" type="password" value="<?php echo e(old('password')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="recovery_code">Recovery Code</label>
                    <input id="recovery_code" name="recovery_code" class="form-control" type="text" value="<?php echo e(old('recovery_code')); ?>">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="host_info">Host Info</label>
                    <textarea id="host_info" name="host_info" class="form-control" rows="3"><?php echo e(old('host_info')); ?></textarea>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button class="btn btn-primary" type="submit">Assign Laptop</button>
            <button class="btn btn-default" type="reset">Cancel</button>
            <a href="<?php echo e(route('laptop_tracker.index')); ?>" class="btn btn-info">View All Laptops</a>
        </div>
    </form>

    <!-- Modal for Employee Search -->
    <div class="modal fade" id="employeeModal" tabindex="-1" role="dialog" aria-labelledby="employeeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="employeeModalLabel">Search Employee</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <!-- Ensure data-dismiss="modal" is present -->
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="text" id="employeeSearchInput" class="form-control" placeholder="Search for employee...">
                    <ul id="employeeList" class="list-group mt-2">
                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item employee-item" data-id="<?php echo e($employee->id); ?>" data-name="<?php echo e($employee->name); ?>" data-phone="<?php echo e($employee->phone); ?>" data-emergency="<?php echo e($employee->emergency_contact); ?>" data-email="<?php echo e($employee->email); ?>">
                                <?php echo e($employee->name); ?> - <?php echo e($employee->phone); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <style>
        .modal-body {
            max-height: 400px; /* Adjust this value to control the height of the scrollable area */
            overflow-y: auto;  /* Enable vertical scrolling */
        }
    </style>

    <script>
    $(document).ready(function() {
        // Autofill details when an employee is selected from the dropdown
        $('#employee_id').on('change', function() {
            var selectedEmployee = $(this).find('option:selected');
            $('#phone').val(selectedEmployee.data('phone'));
            $('#emergency_contact').val(selectedEmployee.data('emergency'));
        }).trigger('change'); // Trigger change event to prefill on page load if employee is selected

        // Search and filter employees in the modal
        $('#employeeSearchInput').on('keyup', function() {
            var value = $(this).val().toLowerCase();
            $('#employeeList .employee-item').filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });

        // Select employee from modal and populate the form fields
        $('#employeeList').on('click', '.employee-item', function() {
            var employeeId = $(this).data('id');
            var employeeName = $(this).data('name');
            var employeePhone = $(this).data('phone');
            var employeeEmergency = $(this).data('emergency');

            $('#employee_id').val(employeeId).trigger('change');
            $('#phone').val(employeePhone);
            $('#emergency_contact').val(employeeEmergency);

            $('#employeeModal').modal('hide');
        });
    });
    </script>
    <script>
        $(document).ready(function() {
    // Autofill details when an employee is selected from the dropdown
    $('#employee_id').on('change', function() {
        var selectedEmployee = $(this).find('option:selected');
        $('#phone').val(selectedEmployee.data('phone'));
        $('#emergency_contact').val(selectedEmployee.data('emergency'));
    }).trigger('change'); // Trigger change event to prefill on page load if employee is selected

    // Search and filter employees in the modal
    $('#employeeSearchInput').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#employeeList .employee-item').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Select employee from modal and populate the form fields
    $('#employeeList').on('click', '.employee-item', function() {
        var employeeId = $(this).data('id');
        var employeePhone = $(this).data('phone');
        var employeeEmergency = $(this).data('emergency');

        $('#employee_id').val(employeeId).trigger('change');
        $('#phone').val(employeePhone);
        $('#emergency_contact').val(employeeEmergency);

        $('#employeeModal').modal('hide');
    });
});

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/create.blade.php ENDPATH**/ ?>