 <!-- Repair History Modal -->
 <div class="modal fade" id="repairHistoryModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog"
    aria-labelledby="repairHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="repairHistoryModalLabel">Repair History for
                    <?php echo e($laptop->serial_number); ?></h5>
                <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">Close</button>
            </div>
            <div class="modal-body">
                <?php if($laptop->repairs->isEmpty()): ?>
                    <p>No repair history available for this laptop.</p>
                <?php else: ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Repair Details</th>
                                <th>Repaired By</th>
                                <th>Cost</th>
                                <th>Approved By</th>
                                <th>Repair Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $laptop->repairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($repair->repair_details); ?></td>
                                    <td><?php echo e($repair->repaired_by); ?></td>
                                    <td><?php echo e($repair->cost); ?></td>
                                    <td><?php echo e($repair->approved_by); ?></td>
                                    
                                    <td><?php echo e($repair->created_at->format('Y-m-d')); ?></td>
                                    <td>
                                        <?php if($repair->bill): ?>
                                            <a href="<?php echo e(asset('storage/' . $repair->bill)); ?>" target="_blank" class="btn btn-info btn-sm">                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(asset('storage/' . $repair->bill)); ?>" download class="btn btn-success btn-sm"> <i class="fas fa-download"></i></a>
                                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editRepairModal-<?php echo e($repair->id); ?>">
                                                <i class="fas fa-edit"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteRepairModal-<?php echo e($repair->id); ?>">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        <?php else: ?>
                                            No bill uploaded
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/repairs/repairHistoryModel.blade.php ENDPATH**/ ?>