@foreach ($laptops as $laptop)
    @foreach ($laptop->repairs as $repair)
        <div class="modal fade" id="deleteRepairModal-{{ $repair->id }}" tabindex="-1" role="dialog"
            aria-labelledby="deleteRepairModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteRepairModalLabel">Delete Repair for Laptop - {{ $laptop->serial_number }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        Are you sure you want to delete this repair record?
                    </div>
                    <div class="modal-footer">
                        <form action="{{ route('repairs.destroy', $repair->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger">Delete Repair</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endforeach
