@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Laptop Allocation History</h3>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Action</th>
                <th>Employee</th>
                <th>Date</th>
                <th>Notes</th>
            </tr>
        </thead>
        <tbody>
            @foreach($laptop->history as $history)
            <tr>
                <td>{{ ucfirst($history->action) }}</td>
                <td>{{ $history->employee->name }}</td>
                <td>{{ \Carbon\Carbon::parse($history->date)->format('Y-m-d') }}</td>
                <td>{{ $history->notes }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <a href="{{ route('laptop_tracker.index') }}" class="btn btn-primary">Back to Laptops</a>
</div>
@endsection
