@extends('layouts.master')

@section('content') <br><br><br>
     <!-- Search and Device Count Overview -->
    <div class="row">
        <div class="col-md-3">
            <form action="{{ route('devices.department', $department) }}" method="GET" class="form-inline mb-3">
                <input type="text" name="search" class="form-control mr-2"
                    placeholder="Search by Serial No or Employee Name" value="{{ request('search') }}">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Total Devices:</strong> {{ $devices->total() }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2 text-center">
                        <strong>Total Laptops:</strong> {{ $totalLaptops }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2 text-center">
                        <strong>Total Desktops:</strong> {{ $totalDesktops }}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Department:</strong> {{ $department }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Devices Table -->
    @if($devices->count() > 0)
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Device Type</th>
                <th>Assign Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($devices as $device)
                <tr>
                    <td>{{ $device->employee ? $device->employee->name : 'Unassigned' }}</td>
                    <td>{{ $device->serial_number }}</td>
                    <td>{{ ucfirst($device->device_type) }}</td>
                    <td>{{ $device->assign_date ? \Carbon\Carbon::parse($device->assign_date)->format('Y-m-d') : 'N/A' }}</td>
                    <td>
                        <!-- Action buttons -->
                        <a href="{{ route('laptop_tracker.edit', $device->id) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>
                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                            data-target="#deleteModal-{{ $device->id }}">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                        <button class="btn btn-info btn-sm" data-toggle="modal"
                            data-target="#viewModal-{{ $device->id }}">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button class="btn btn-secondary btn-sm" data-toggle="modal"
                            data-target="#reassignModal-{{ $device->id }}">
                            <i class="fas fa-exchange-alt"></i> Reassign
                        </button>
                        <button class="btn btn-dark btn-sm" data-toggle="modal"
                            data-target="#historyModal-{{ $device->id }}">
                            <i class="fas fa-history"></i> History
                        </button>
                        <button class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#addAccessoryModal-{{ $device->id }}">
                        <i class="fas fa-plus"></i> Add Accessory
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                    data-target="#viewAccessoryModal-{{ $device->id }}">
                    <i class="fas fa-eye"></i> View Accessories
                </button>
                        <button class="btn btn-primary btn-sm" data-toggle="modal"
                            data-target="#repairModal-{{ $device->id }}">
                            <i class="fas fa-tools"></i> Repair
                        </button>
                        <button class="btn btn-info btn-sm" data-toggle="modal"
                            data-target="#repairHistoryModal-{{ $device->id }}">
                            <i class="fas fa-history"></i> Repair History
                        </button>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{ $devices->links() }} <!-- Pagination links -->

    @else
    <p>No devices found in the {{ $department }} department.</p>
    @endif
 @endsection
