<!-- View Accessories Modal -->
@foreach ($laptops as $laptop)
    <div class="modal fade" id="viewAccessoryModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
        aria-labelledby="viewAccessoryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewAccessoryModalLabel">Accessories for Laptop: {{ $laptop->serial_number }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @if ($laptop->accessories->isEmpty())
                        <p>No accessories found for this laptop.</p>
                    @else
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Accessory Name</th>
                                    <th>Price</th>
                                    <th>Approved By</th>
                                    <th>Bill</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($laptop->accessories as $accessory)
                                    <tr>
                                        <td>{{ $accessory->name }}</td>
                                        <td>{{ $accessory->price }}</td>
                                        <td>{{ $accessory->approved_by ?? 'N/A' }}</td>
                                        <td>
                                            @if ($accessory->bill_file)
                                                <a href="{{ Storage::url($accessory->bill_file) }}" target="_blank" class="btn btn-info btn-sm">
                                                    <i class="fa fa-eye"></i> View Bill
                                                </a>
                                                <a href="{{ route('accessories.download', $accessory->id) }}" class="btn btn-success btn-sm">
                                                    <i class="fa fa-download"></i> Download Bill
                                                </a>
                                                <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editAccessoryModal-{{ $accessory->id }}">
                                                    <i class="fas fa-edit"></i> Edit
                                                </button>
                                                <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteAccessoryModal-{{ $accessory->id }}">
                                                    <i class="fas fa-trash-alt"></i> Delete
                                                </button>
                                            @else
                                                No bill uploaded
                                            @endif
                                           
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
@endforeach