    <?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateLaptopsAndRelatedTables extends Migration
    {
        /**
         * Run the migrations.
         *
         * @return void
         */
        public function up()
        {
            Schema::create('laptops', function (Blueprint $table) {
                $table->id();
                $table->string('serial_number')->unique();
                $table->string('laptop_type');  
                $table->string('company_name');
                $table->date('assign_date')->nullable();
                $table->string('microsoft_account')->nullable();
                $table->string('password')->nullable();
                $table->string('recovery_code')->nullable();
                $table->foreignId('employee_id')->nullable()->constrained()->onDelete('cascade'); // Nullable for reassignment or unassigned laptops
                $table->boolean('is_personal')->default(false);
                $table->text('host_info')->nullable();  
                $table->timestamps();
            });

            Schema::create('laptop_histories', function (Blueprint $table) {
                $table->id();
                $table->foreignId('laptop_id')->constrained()->onDelete('cascade');
                $table->foreignId('employee_id')->constrained()->onDelete('cascade');
                $table->string('action');  
                $table->date('date');
                $table->text('notes')->nullable();
                $table->timestamps();
            });

            Schema::create('laptop_repairs', function (Blueprint $table) {
                $table->id();
                $table->foreignId('laptop_id')->constrained()->onDelete('cascade');
                $table->string('repair_details');
                $table->string('repaired_by');
                $table->decimal('cost', 8, 2);
                $table->string('approved_by')->nullable();
                $table->timestamps();
            });
        }

        /**
         * Reverse the migrations.
         *
         * @return void
         */
        public function down()
        {
            Schema::dropIfExists('laptop_repairs');
            Schema::dropIfExists('laptop_histories');
            Schema::dropIfExists('laptops');
        }
    }
