<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LaptopHistory extends Model
{
    use HasFactory;
    protected $fillable = ['laptop_id', 'employee_id', 'action', 'date', 'notes'];

    public function laptop()
    {
        return $this->belongsTo(Laptop::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
