<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Laptop;
use App\Models\LaptopRepair;    

class LaptopRepairController extends Controller
{
    public function index()
    {
        $repairs = LaptopRepair::with('laptop')->orderBy('repair_date', 'desc')->paginate(10);
        return view('repairs.index', compact('repairs'));
    }

    public function create($laptop_id)
    {
        $laptop = Laptop::findOrFail($laptop_id);
        return view('repairs.create', compact('laptop'));
    }

    public function store(Request $request, $laptop_id)
    {
        $request->validate([
            'repair_details' => 'required|string|max:255',
            'repaired_by' => 'required|string|max:255',
            'cost' => 'required|numeric|min:0',
            'repair_date' => 'required|date',
            'approved_by' => 'nullable|string|max:255',
            'notes' => 'nullable|string',
        ]);

        LaptopRepair::create([
            'laptop_id' => $laptop_id,
            'repair_details' => $request->repair_details,
            'repaired_by' => $request->repaired_by,
            'cost' => $request->cost,
            'repair_date' => $request->repair_date,
            'approved_by' => $request->approved_by,
            'notes' => $request->notes,
        ]);

        return redirect()->route('repairs.index')->with('success', 'Repair record added successfully.');
    }

    public function show($id)
    {
        $repair = LaptopRepair::with('laptop')->findOrFail($id);
        return view('repairs.show', compact('repair'));
    }
}
