

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Laptop Details</h3>

    <table class="table table-bordered">
        <tr>
            <th>Serial Number</th>
            <td><?php echo e($laptop->serial_number); ?></td>
        </tr>
        <tr>
            <th>Model Name</th>
            <td><?php echo e($laptop->model_name); ?></td>
        </tr>
        <tr>
            <th>Company Name</th>
            <td><?php echo e($laptop->company_name); ?></td>
        </tr>
        <tr>
            <th>RAM</th>
            <td><?php echo e($laptop->ram); ?></td>
        </tr>
        <tr>
            <th>Storage</th>
            <td><?php echo e($laptop->storage); ?></td>
        </tr>
        <tr>
            <th>SSD/HDD</th>
            <td><?php echo e(ucfirst($laptop->ssd_hdd)); ?></td>
        </tr>
        <tr>
            <th>Processor</th>
            <td><?php echo e($laptop->processor); ?></td>
        </tr>
        <tr>
            <th>Generation</th>
            <td><?php echo e($laptop->generation); ?></td>
        </tr>
        <tr>
            <th>Purchase Date</th>
            <td><?php echo e($laptop->purchase_date ? \Carbon\Carbon::parse($laptop->purchase_date)->format('Y-m-d') : 'N/A'); ?></td>
        </tr>
        <tr>
            <th>Purchase Amount</th>
            <td><?php echo e($laptop->purchase_amount ? '₹' . number_format($laptop->purchase_amount, 2) : 'N/A'); ?></td>
        </tr>
        <tr>
            <th>Warranty Status</th>
            <td><?php echo e(ucfirst($laptop->warranty_status)); ?></td>
        </tr>
        <tr>
            <th>Warranty Expiry Date</th>
            <td><?php echo e($laptop->warranty_expiry_date ? \Carbon\Carbon::parse($laptop->warranty_expiry_date)->format('Y-m-d') : 'N/A'); ?></td>
        </tr>
        <tr>
            <th>Asset Tag</th>
            <td><?php echo e($laptop->asset_tag); ?></td>
        </tr>
        <tr>
            <th>Notes</th>
            <td><?php echo e($laptop->notes); ?></td>
        </tr>

        <!-- Purchase Bill/Invoice Download -->
        <tr>
            <th>Purchase Invoice</th>
            <td>
                <?php if($laptop->purchase_bill): ?>
                    <a href="<?php echo e(asset('storage/' . $laptop->purchase_bill)); ?>" class="btn btn-info" download>
                        Download Invoice
                    </a>
                <?php else: ?>
                    <span>No Invoice Available</span>
                <?php endif; ?>
            </td>
        </tr>
    </table>

    <a href="<?php echo e(route('new_laptops.index')); ?>" class="btn btn-default">Back to List</a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/new_laptops/show.blade.php ENDPATH**/ ?>