

<?php $__env->startSection('content'); ?>
<div class="col-sm-12 col-md-12 full-width-content">

    <div class="row">
        <form action="<?php echo e(route('laptop_tracker.searchLaptops')); ?>" method="GET" class="form-inline mb-3">
            <input type="text" name="search" class="form-control mr-2"
                placeholder="Search by Serial No or Employee Name" value="<?php echo e(request('search')); ?>">
            <button type="submit" class="btn btn-primary">Search</button>
        </form>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Total Laptops:</strong> <?php echo e($totalLaptops); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2 text-center">
                        <strong>Total Dell Laptops:</strong> <?php echo e($totalDellLaptops); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2 text-center">
                        <strong>Total Lenovo Laptops:</strong> <?php echo e($totalLenovoLaptops); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2 text-center">
                        <a href="<?php echo e(route('employees.withoutLaptop')); ?>" class="text-dark text-decoration-none">
                            <strong>Total Employees Without Laptop:</strong> <?php echo e($employeesWithoutLaptop); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <h3 class="heading">Assigned Laptops</h3>
    <div class="row">
        <div class="col-md-3">
            <form action="<?php echo e(route('laptop_tracker.index')); ?>" method="GET" class="form-inline mb-3">
                <input type="text" name="search" class="form-control mr-2"
                    placeholder="Search by Serial No or Employee Name" value="<?php echo e(request('search')); ?>">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2">
                        <strong>Total Laptops:</strong> <?php echo e($totalLaptops); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2">
                        <strong>Total Dell Laptops:</strong> <?php echo e($totalDellLaptops); ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2">
                        <strong>Total Lenovo Laptops:</strong> <?php echo e($totalLenovoLaptops); ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2">
                        <a href="<?php echo e(route('employees.withoutLaptop')); ?>">
                            <strong>Total Employees Without Laptop:</strong> <?php echo e($employeesWithoutLaptop); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(session('success')): ?>
    <div id="response-message" class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Device Type</th>
                <th>Assign Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $laptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($laptop->employee ? $laptop->employee->name : 'Unassigned'); ?></td>
                <td><?php echo e($laptop->serial_number); ?></td>
                <td><?php echo e(ucfirst($laptop->device_type)); ?></td>
                <td><?php echo e($laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A'); ?></td>

                <td>
                    <!-- Action Buttons -->
                    <a href="<?php echo e(route('laptop_tracker.edit', $laptop->id)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i>
                    </a>
                    <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-eye"></i>
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                        data-target="#reassignModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-exchange-alt"></i> Reassign
                    </button>
                    <button class="btn btn-dark btn-sm" data-toggle="modal" data-target="#historyModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-history"></i> History
                    </button>
                    <button class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#addAccessoryModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-plus"></i> Add Accessory
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                        data-target="#viewAccessoryModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-eye"></i> View Accessories
                    </button>
                    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#repairModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-tools"></i> Repair
                    </button>
                    <button class="btn btn-info btn-sm" data-toggle="modal"
                        data-target="#repairHistoryModal-<?php echo e($laptop->id); ?>">
                        <i class="fas fa-history"></i> Repair History
                    </button>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($laptops->links()); ?> <!-- Pagination -->
</div>

<!-- Include Modals -->
<?php $__currentLoopData = $laptops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $laptop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- View Modal -->
<div class="modal fade" id="viewModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">Laptop Details</h5>
                <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">Close</button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr>
                        <th>Serial Number</th>
                        <td><?php echo e($laptop->serial_number); ?></td>
                    </tr>
                    <tr>
                        <th>Laptop Type</th>
                        <td><?php echo e(ucfirst($laptop->laptop_type)); ?></td>
                    </tr>
                    <tr>
                        <th>Company Name</th>
                        <td><?php echo e($laptop->company_name); ?></td>
                    </tr>
                    <tr>
                        <th>RAM</th>
                        <td><?php echo e($laptop->ram); ?></td>
                    </tr>
                    <tr>
                        <th>SSD/Hard-Disk</th>
                        <td><?php echo e($laptop->storage); ?></td>
                    </tr>
                    <tr>
                        <th>Assign Date</th>
                        <td><?php echo e($laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A'); ?>

                        </td>
                    </tr>
                    <tr>
                        <th>Microsoft Account</th>
                        <td><?php echo e($laptop->microsoft_account); ?></td>
                    </tr>
                    <tr>
                        <th>Password</th>
                        <td><?php echo e($laptop->password); ?></td>
                    </tr>
                    <tr>
                        <th>Recovery Code</th>
                        <td><?php echo e($laptop->recovery_code); ?></td>
                    </tr>
                    <tr>
                        <th>Host Info</th>
                        <td><?php echo e($laptop->host_info); ?></td>
                    </tr>
                    <tr>
                        <th>Assigned To</th>
                        <td><?php echo e($laptop->employee ? $laptop->employee->name : 'Unassigned'); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Reassign Modal -->
<div class="modal fade" id="reassignModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog"
    aria-labelledby="reassignModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reassignModalLabel">Reassign Laptop</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('laptop_tracker.reassign', $laptop->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Select New Employee</label>
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($employee->id); ?>">
                                <?php echo e($employee->name); ?>

                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="notes">Reassignment Notes</label>
                        <textarea id="notes" name="notes" class="form-control" rows="3"><?php echo e(old('notes')); ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Reassign</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog"
    aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Delete Laptop Record</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this laptop record?
            </div>
            <div class="modal-footer">
                <form action="<?php echo e(route('laptop_tracker.destroy', $laptop->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- History Modal -->
<div class="modal fade" id="historyModal-<?php echo e($laptop->id); ?>" tabindex="-1" role="dialog"
    aria-labelledby="historyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="historyModalLabel">Laptop History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Employee</th>
                            <th>Date</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $laptop->history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(ucfirst($history->action)); ?></td>
                            <td><?php echo e($history->employee->name); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($history->date)->format('Y-m-d')); ?></td>
                            <td><?php echo e($history->notes); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Include other modals like repair, accessory management, etc. here -->
<?php echo $__env->make('pages.laptop_tracker.repairs.repairModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.repairs.repairHistoryModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.repairs.editRepairModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.repairs.deleteRepairModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('pages.laptop_tracker.accessories.viewModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.accessories.addModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.accessories.deleteModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('pages.laptop_tracker.accessories.editModel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<script>
    $(document).on('show.bs.modal', '.modal', function () {
        var zIndex = 1040 + (10 * $('.modal:visible').length);
        $(this).css('z-index', zIndex);
        setTimeout(function () {
            $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
        }, 0);
    });

    $(document).on('hidden.bs.modal', '.modal', function () {
        if ($('.modal:visible').length) {
            $('body').addClass('modal-open');
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\madalasa hospital\Software\softwareMadalasaHospital\resources\views/pages/laptop_tracker/devices/laptops.blade.php ENDPATH**/ ?>