<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\CampController;
use App\Http\Controllers\ComplianceController;
use App\Http\Controllers\FollowUpController;
use App\Http\Controllers\LaptopTrackerController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\AccessoryController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\NewLaptopController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
 
 
Route::get('',[AuthController::class , 'index'])->name('login');
Route::post('',[AuthController::class , 'store'])->name('store.index');
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

 
Route::middleware(['auth'])->group(function () {
    
    // Superadmin routes
    Route::middleware(['role:superadmin'])->group(function () {
        Route::get('/superadmin/dashboard', [AuthController::class, 'superadminDashboard'])->name('superadmin.dashboard');
     });

    // Admin routes
    Route::middleware(['role:admin'])->group(function () {
        Route::get('/admin/dashboard', [AuthController::class, 'adminDashboard'])->name('admin.dashboard');
     });

    // Camp routes
    Route::middleware(['role:camp'])->group(function () {
        Route::get('/camp/dashboard', [AuthController::class, 'officeDashboard'])->name('office.dashboard');
        Route::get('/camp/create',[CampController::class , 'create'])->name('camp.create');
        Route::post('/camp/store', [CampController::class, 'store'])->name('camp.store');
        Route::get('/camp/index', [CampController::class, 'index'])->name('camp.index');
        Route::get('/camp/{id}/edit', [CampController::class, 'edit'])->name('camp.edit');
        Route::put('/camp/{id}/update', [CampController::class, 'update'])->name('camp.update');
        Route::delete('/camp/{id}/destroy', [CampController::class, 'destroy'])->name('camp.destroy');
        

     });


       // FollowUp routes
    Route::middleware(['role:followup'])->group(function () {
        Route::get('/followup/dashboard', [AuthController::class, 'followupDashboard'])->name('followup.dashboard');
        Route::get('/follow-up/create', [FollowUpController::class, 'create'])->name('followup.create');
        Route::post('/follow-up/store', [FollowUpController::class, 'store'])->name('followup.store');
        Route::get('/follow-up/index', [FollowUpController::class, 'index'])->name('followup.index');


     });

     // Laptop Tracker routes
    Route::middleware(['role:laptop_tracker'])->group(function () {
        Route::get('/laptop-tracker/dashboard', [AuthController::class, 'laptopTrackerDashboard'])->name('laptop_tracker.dashboard');
        // Add other laptop tracker-specific routes here
        Route::get('/laptops', [LaptopTrackerController::class, 'index'])->name('laptop_tracker.index');
        Route::get('/laptop-tracker/create/{employee_id?}', [LaptopTrackerController::class, 'create'])->name('laptop_tracker.create');
        Route::post('/laptops/store', [LaptopTrackerController::class, 'store'])->name('laptop_tracker.store');
        Route::get('/laptops/{id}/edit', [LaptopTrackerController::class, 'edit'])->name('laptop_tracker.edit');
        Route::put('/laptops/{id}', [LaptopTrackerController::class, 'update'])->name('laptop_tracker.update');
        Route::delete('/laptops/{id}', [LaptopTrackerController::class, 'destroy'])->name('laptop_tracker.destroy');
        Route::get('laptop_tracker/history/{id}', [LaptopTrackerController::class, 'history'])->name('laptop_tracker.history');
        Route::put('/laptops/reassign/{id}', [LaptopTrackerController::class, 'reassign'])->name('laptop_tracker.reassign');
        Route::post('/laptop-tracker/{id}/repair', [LaptopTrackerController::class, 'repair'])->name('laptop_tracker.repair');
        Route::get('/repairs/edit/{id}', [LaptopTrackerController::class, 'editRepairModel'])->name('repairs.edit');
        Route::put('/repairs/update/{id}', [LaptopTrackerController::class, 'updateRepairModel'])->name('repairs.update');
        Route::delete('/repairs/delete/{id}', [LaptopTrackerController::class, 'destroyRepairModel'])->name('repairs.destroy');
        Route::get('/laptops/active/{department}', [LaptopTrackerController::class, 'activeLaptopsByDepartment'])->name('laptops.active_by_department');
        Route::get('/employees/without-laptop', [EmployeeController::class, 'employeesWithoutLaptop'])->name('employees.withoutLaptop');

        Route::get('/devices/department/{department}', [LaptopTrackerController::class, 'showDevicesByDepartment'])->name('devices.department');

        // Separate routes for each device type
        Route::get('/devices/desktops', [DeviceController::class, 'desktops'])->name('devices.desktops');
        Route::get('/devices/laptops', [DeviceController::class, 'laptops'])->name('devices.laptops');
        Route::get('/devices/mobiles', [DeviceController::class, 'mobiles'])->name('devices.mobiles');
        Route::get('/devices/tablets', [DeviceController::class, 'tablets'])->name('devices.tablets');
        Route::get('/laptops/search', [DeviceController::class, 'searchLaptops'])->name('laptop_tracker.searchLaptops');


        // New Laptop routes
        Route::post('/new/laptop', [NewLaptopController::class, 'store'])->name('new_laptops.store'); // Store (create)
        Route::get('/new/laptop', [NewLaptopController::class, 'create'])->name('new_laptops.create'); // Create
        Route::get('/new/show/{id}', [NewLaptopController::class, 'show'])->name('new_laptops.show'); // Show single laptop
        Route::get('/new/index', [NewLaptopController::class, 'index'])->name('new_laptops.index'); // List
        Route::put('/new/update/{id}', [NewLaptopController::class, 'update'])->name('new_laptops.update'); // Update laptop
        Route::get('/new/edit/{id}', [NewLaptopController::class, 'edit'])->name('new_laptops.edit'); // Edit form
        Route::delete('/new/destroy/{id}', [NewLaptopController::class, 'destroy'])->name('new_laptops.destroy'); // Delete laptop

        Route::post('/accessories/store', [AccessoryController::class, 'store'])->name('accessories.store');
        Route::get('/accessories/download/{id}', [AccessoryController::class, 'download'])->name('accessories.download');
        Route::get('/accessories/edit/{id}', [AccessoryController::class, 'edit'])->name('accessories.edit');
        Route::put('/accessories/update/{id}', [AccessoryController::class, 'update'])->name('accessories.update');
        Route::delete('/accessories/delete/{id}', [AccessoryController::class, 'destroy'])->name('accessories.destroy');

        //Employee
        Route::get('/employees', [EmployeeController::class, 'index'])->name('employees.index');
        Route::get('/create', [EmployeeController::class, 'create'])->name('employees.create');
        Route::post('/create', [EmployeeController::class, 'store'])->name('employees.store');
        Route::get('/employees/{employee}/edit', [EmployeeController::class, 'edit'])->name('employees.edit');
        Route::put('/employees/{employee}', [EmployeeController::class, 'update'])->name('employees.update');
        Route::delete('/employees/{employee}', [EmployeeController::class, 'destroy'])->name('employees.destroy');



        
      });

    // General dashboard route accessible to all authenticated users
    Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('dashboard');
});


