@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12">
    <h3 class="heading">Add Camp Details</h3>
    @if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @elseif(session('error'))
    <div id="response-message" class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <form id="campForm" class="form_validation_reg" action="{{ route('camp.store') }}" method="POST">
        @csrf
        <div class="formSep">
            <div class="row">
                <div class="col-sm-2 col-md-2">
                    <label>Camp Location <span class="f_req">*</span></label>
                    <input name="camp_location" class="form-control" type="text" value="{{ old('camp_location', session('last_camp_location', '')) }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Camp Date <span class="f_req">*</span></label>
                    <input name="camp_date" class="form-control" type="date" value="{{ old('camp_date', session('last_camp_date', '')) }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Pt Name <span class="f_req">*</span></label>
                    <input name="pt_name" class="form-control" type="text" value="{{ old('pt_name') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Phone <span class="f_req">*</span></label>
                    <input name="phone" class="form-control" type="text" value="{{ old('phone') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="feedback-status">Phone Status <span class="f_req">*</span></label>

                <select name="phone_status" id="phone-status" class="form-control">

                    <option value="">-select-</option>
                    <option value="Connected" {{ old('phone_status') == 'Connected' ? 'selected' : '' }}>Connected</option>
                    <option value="Phone Cut" {{ old('phone_status') == 'Phone Cut' ? 'selected' : '' }}>Phone Cut</option>
                    <option value="Switched Off" {{ old('phone_status') == 'Switched Off' ? 'selected' : '' }}>Phone Switched Off</option>
                    <option value="Out of Reach" {{ old('phone_status') == 'Out of Reach' ? 'selected' : '' }}>Out of Reach</option>
                    <option value="Not Picking" {{ old('phone_status') == 'Not Picking' ? 'selected' : '' }}>Not Picking Up</option>
                    <option value="Busy" {{ old('phone_status') == 'Busy' ? 'selected' : '' }}>Busy</option>
                    <option value="No Answer" {{ old('phone_status') == 'No Answer' ? 'selected' : '' }}>No Answer</option>
                    <option value="Call Dropped" {{ old('phone_status') == 'Call Dropped' ? 'selected' : '' }}>Call Dropped</option>
                    <option value="Voicemail" {{ old('phone_status') == 'Voicemail' ? 'selected' : '' }}>Voicemail</option>
                    <option value="Number Not in Service" {{ old('phone_status') == 'Number Not in Service' ? 'selected' : '' }}>Number Not in Service</option>
                </select>
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Age</label>
                    <input name="age" class="form-control" type="number" value="{{ old('age') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>Gender</label>
                    <label class="radio-inline">
                        <input value="Male" name="gender" type="radio" {{ old('gender') == 'Male' ? 'checked' : '' }}>
                        Male
                    </label>
                    <label class="radio-inline">
                        <input value="Female" name="gender" type="radio" {{ old('gender') == 'Female' ? 'checked' : '' }}>
                        Female
                    </label>
                </div>
                
                <div class="col-sm-2 col-md-2">
                    <label>B.P (mm/hg)</label>
                    <input name="bp" class="form-control" type="text" value="{{ old('bp') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label>RBS (mg/dl)</label>
                    <input name="rbs" class="form-control" type="text" value="{{ old('rbs') }}">
                </div>
                <div class="col-sm-2 col-md-2">
                    <label for="feedback-status">Dr. Consultation <span class="f_req">*</span></label>
                    <select name="feedback_status" id="feedback-status" class="form-control">
                        <option value="">-select-</option>
                        <option value="Yes" {{ old('feedback_status') == 'Yes' ? 'selected' : '' }}>Yes</option>
                        <option value="No" {{ old('feedback_status') == 'No' ? 'selected' : '' }}>No</option>
                
                    </select>
                </div>
            </div>
        </div>
        
        <div class="formSep">
            <label>Remark</label>
            <textarea name="remark" id="remark" cols="10" rows="3" class="form-control">{{ old('remark') }}</textarea>
        </div>
        
        <div class="form-actions">
            <button class="btn btn-primary" type="submit">Save & Add Next</button>
            <button class="btn btn-default" type="reset">Cancel</button>
            <a href="{{ route('camp.index') }}" class="btn btn-info">View All Camps</a>

        </div>
    </form>
    <div id="response-message" class="alert" style="display:none;"></div>
</div>
@endsection
