   <!-- Repair Modal -->
   <div class="modal fade" id="repairModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
    aria-labelledby="repairModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="repairModalLabel">Repair Laptop - {{ $laptop->serial_number }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('laptop_tracker.repair', $laptop->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="repair_details">Repair Details</label>
                        <textarea id="repair_details" name="repair_details" class="form-control" rows="3" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="repaired_by">Repaired By</label>
                        <input type="text" id="repaired_by" name="repaired_by" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="cost">Repair Cost</label>
                        <input type="number" id="cost" name="cost" class="form-control" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="approved_by">Approved By</label>
                        <input type="text" id="approved_by" name="approved_by" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="bill">Upload Bill</label>
                        <input type="file" id="bill" name="bill" class="form-control-file">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Submit Repair</button>
                </div>
            </form>
        </div>
    </div>
</div>