 <!-- Repair History Modal -->
 <div class="modal fade" id="repairHistoryModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
    aria-labelledby="repairHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="repairHistoryModalLabel">Repair History for
                    {{ $laptop->serial_number }}</h5>
                <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">Close</button>
            </div>
            <div class="modal-body">
                @if ($laptop->repairs->isEmpty())
                    <p>No repair history available for this laptop.</p>
                @else
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Repair Details</th>
                                <th>Repaired By</th>
                                <th>Cost</th>
                                <th>Approved By</th>
                                <th>Repair Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($laptop->repairs as $repair)
                                <tr>
                                    <td>{{ $repair->repair_details }}</td>
                                    <td>{{ $repair->repaired_by }}</td>
                                    <td>{{ $repair->cost }}</td>
                                    <td>{{ $repair->approved_by }}</td>
                                    
                                    <td>{{ $repair->created_at->format('Y-m-d') }}</td>
                                    <td>
                                        @if($repair->bill)
                                            <a href="{{ asset('storage/' . $repair->bill) }}" target="_blank" class="btn btn-info btn-sm">                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ asset('storage/' . $repair->bill) }}" download class="btn btn-success btn-sm"> <i class="fas fa-download"></i></a>
                                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#editRepairModal-{{ $repair->id }}">
                                                <i class="fas fa-edit"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteRepairModal-{{ $repair->id }}">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        @else
                                            No bill uploaded
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>