@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Laptop Details</h3>

    <table class="table table-bordered">
        <tr>
            <th>Serial Number</th>
            <td>{{ $laptop->serial_number }}</td>
        </tr>
        <tr>
            <th>Model Name</th>
            <td>{{ $laptop->model_name }}</td>
        </tr>
        <tr>
            <th>Company Name</th>
            <td>{{ $laptop->company_name }}</td>
        </tr>
        <tr>
            <th>RAM</th>
            <td>{{ $laptop->ram }}</td>
        </tr>
        <tr>
            <th>Storage</th>
            <td>{{ $laptop->storage }}</td>
        </tr>
        <tr>
            <th>SSD/HDD</th>
            <td>{{ ucfirst($laptop->ssd_hdd) }}</td>
        </tr>
        <tr>
            <th>Processor</th>
            <td>{{ $laptop->processor }}</td>
        </tr>
        <tr>
            <th>Generation</th>
            <td>{{ $laptop->generation }}</td>
        </tr>
        <tr>
            <th>Purchase Date</th>
            <td>{{ $laptop->purchase_date ? \Carbon\Carbon::parse($laptop->purchase_date)->format('Y-m-d') : 'N/A' }}</td>
        </tr>
        <tr>
            <th>Purchase Amount</th>
            <td>{{ $laptop->purchase_amount ? '₹' . number_format($laptop->purchase_amount, 2) : 'N/A' }}</td>
        </tr>
        <tr>
            <th>Warranty Status</th>
            <td>{{ ucfirst($laptop->warranty_status) }}</td>
        </tr>
        <tr>
            <th>Warranty Expiry Date</th>
            <td>{{ $laptop->warranty_expiry_date ? \Carbon\Carbon::parse($laptop->warranty_expiry_date)->format('Y-m-d') : 'N/A' }}</td>
        </tr>
        <tr>
            <th>Asset Tag</th>
            <td>{{ $laptop->asset_tag }}</td>
        </tr>
        <tr>
            <th>Notes</th>
            <td>{{ $laptop->notes }}</td>
        </tr>

        <!-- Purchase Bill/Invoice Download -->
        <tr>
            <th>Purchase Invoice</th>
            <td>
                @if($laptop->purchase_bill)
                    <a href="{{ asset('storage/' . $laptop->purchase_bill) }}" class="btn btn-info" download>
                        Download Invoice
                    </a>
                @else
                    <span>No Invoice Available</span>
                @endif
            </td>
        </tr>
    </table>

    <a href="{{ route('new_laptops.index') }}" class="btn btn-default">Back to List</a>
</div>
@endsection
