@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">List of Laptops</h3>

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(session('error'))
    <div id="response-message" class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <table class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>Serial Number</th>
                <th>Model Name</th>
                <th>Company Name</th>
                <th>RAM</th>
                <th>Storage</th>
                <th>SSD/HDD</th>
                <th>Processor</th>
                <th>Generation</th>
                <th>Purchase Date</th>
                <th>Purchase Amount</th>
                <th>Warranty Status</th>
                <th>Warranty Expiry Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($laptops as $laptop)
            <tr>
                <td>{{ $laptop->serial_number }}</td>
                <td>{{ $laptop->model_name }}</td>
                <td>{{ $laptop->company_name }}</td>
                <td>{{ $laptop->ram }}</td>
                <td>{{ $laptop->storage }}</td>
                <td>{{ ucfirst($laptop->ssd_hdd) }}</td>
                <td>{{ $laptop->processor }}</td>
                <td>{{ $laptop->generation }}</td>
                <td>{{ $laptop->purchase_date ? \Carbon\Carbon::parse($laptop->purchase_date)->format('Y-m-d') : 'N/A' }}</td>
                <td>{{ $laptop->purchase_amount ? '₹' . number_format($laptop->purchase_amount, 2) : 'N/A' }}</td>
                <td>{{ ucfirst($laptop->warranty_status) }}</td>
                <td>{{ $laptop->warranty_expiry_date ? \Carbon\Carbon::parse($laptop->warranty_expiry_date)->format('Y-m-d') : 'N/A' }}</td>
                <td>
                    <!-- View Button with 'eye' icon -->
                    <a href="{{ route('new_laptops.show', $laptop->id) }}" class="btn btn-info">
                        <span class="fa fa-eye"></span>  
                    </a>
                
                    <!-- Edit Button with 'pencil' icon -->
                    <a href="{{ route('new_laptops.edit', $laptop->id) }}" class="btn btn-warning">
                        <span class="fa fa-pencil"></span>  
                    </a>
                
                    <!-- Delete Button with 'trash' icon -->
                    <form action="{{ route('new_laptops.destroy', $laptop->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-danger" type="submit" onclick="return confirm('Are you sure you want to delete this laptop?')">
                            <span class="fa fa-trash"></span>  
                        </button>
                    </form>
                </td>
                
            </tr>
            @endforeach
        </tbody>
    </table>

    <a href="{{ route('new_laptops.create') }}" class="btn btn-primary">Add New Laptop</a>
</div>
@endsection
