@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">

    <div class="row">
        <form action="{{ route('laptop_tracker.searchLaptops') }}" method="GET" class="form-inline mb-3">
            <input type="text" name="search" class="form-control mr-2"
                placeholder="Search by Serial No or Employee Name" value="{{ request('search') }}">
            <button type="submit" class="btn btn-primary">Search</button>
        </form>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2 text-center">
                        <strong>Total Laptops:</strong> {{ $totalLaptops }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2 text-center">
                        <strong>Total Dell Laptops:</strong> {{ $totalDellLaptops }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2 text-center">
                        <strong>Total Lenovo Laptops:</strong> {{ $totalLenovoLaptops }}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2 text-center">
                        <a href="{{ route('employees.withoutLaptop') }}" class="text-dark text-decoration-none">
                            <strong>Total Employees Without Laptop:</strong> {{ $employeesWithoutLaptop }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <h3 class="heading">Assigned Laptops</h3>
    <div class="row">
        <div class="col-md-3">
            <form action="" method="GET" class="form-inline mb-3">
                <input type="text" name="search" class="form-control mr-2"
                    placeholder="Search by Serial No or Employee Name" value="{{ request('search') }}">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-2">
                    <div class="alert alert-info p-2">
                        <strong>Total Laptops:</strong> {{ $totalLaptops }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-success p-2">
                        <strong>Total Dell Laptops:</strong> {{ $totalDellLaptops }}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="alert alert-warning p-2">
                        <strong>Total Lenovo Laptops:</strong> {{ $totalLenovoLaptops }}
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="alert alert-info p-2">
                        <a href="{{ route('employees.withoutLaptop') }}">
                            <strong>Total Employees Without Laptop:</strong> {{ $employeesWithoutLaptop }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Device Type</th>
                <th>Assign Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($laptops as $laptop)
            <tr>
                <td>{{ $laptop->employee ? $laptop->employee->name : 'Unassigned' }}</td>
                <td>{{ $laptop->serial_number }}</td>
                <td>{{ ucfirst($laptop->device_type) }}</td>
                <td>{{ $laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A' }}</td>

                <td>
                    <!-- Action Buttons -->
                    <a href="{{ route('laptop_tracker.edit', $laptop->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i>
                    </a>
                    <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal-{{ $laptop->id }}">
                        <i class="fas fa-trash-alt"></i>
                    </button>
                    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewModal-{{ $laptop->id }}">
                        <i class="fas fa-eye"></i>
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                        data-target="#reassignModal-{{ $laptop->id }}">
                        <i class="fas fa-exchange-alt"></i> Reassign
                    </button>
                    <button class="btn btn-dark btn-sm" data-toggle="modal" data-target="#historyModal-{{ $laptop->id }}">
                        <i class="fas fa-history"></i> History
                    </button>
                    <button class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#addAccessoryModal-{{ $laptop->id }}">
                        <i class="fas fa-plus"></i> Add Accessory
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal"
                        data-target="#viewAccessoryModal-{{ $laptop->id }}">
                        <i class="fas fa-eye"></i> View Accessories
                    </button>
                    <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#repairModal-{{ $laptop->id }}">
                        <i class="fas fa-tools"></i> Repair
                    </button>
                    <button class="btn btn-info btn-sm" data-toggle="modal"
                        data-target="#repairHistoryModal-{{ $laptop->id }}">
                        <i class="fas fa-history"></i> Repair History
                    </button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $laptops->links() }} <!-- Pagination -->
</div>

<!-- Include Modals -->
@foreach ($laptops as $laptop)
<!-- View Modal -->
<div class="modal fade" id="viewModal-{{ $laptop->id }}" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">Laptop Details</h5>
                <button type="button" class="btn btn-secondary ml-auto" data-dismiss="modal">Close</button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr>
                        <th>Serial Number</th>
                        <td>{{ $laptop->serial_number }}</td>
                    </tr>
                    <tr>
                        <th>Laptop Type</th>
                        <td>{{ ucfirst($laptop->laptop_type) }}</td>
                    </tr>
                    <tr>
                        <th>Company Name</th>
                        <td>{{ $laptop->company_name }}</td>
                    </tr>
                    <tr>
                        <th>RAM</th>
                        <td>{{ $laptop->ram }}</td>
                    </tr>
                    <tr>
                        <th>SSD/Hard-Disk</th>
                        <td>{{ $laptop->storage }}</td>
                    </tr>
                    <tr>
                        <th>Assign Date</th>
                        <td>{{ $laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A' }}
                        </td>
                    </tr>
                    <tr>
                        <th>Microsoft Account</th>
                        <td>{{ $laptop->microsoft_account }}</td>
                    </tr>
                    <tr>
                        <th>Password</th>
                        <td>{{ $laptop->password }}</td>
                    </tr>
                    <tr>
                        <th>Recovery Code</th>
                        <td>{{ $laptop->recovery_code }}</td>
                    </tr>
                    <tr>
                        <th>Host Info</th>
                        <td>{{ $laptop->host_info }}</td>
                    </tr>
                    <tr>
                        <th>Assigned To</th>
                        <td>{{ $laptop->employee ? $laptop->employee->name : 'Unassigned' }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Reassign Modal -->
<div class="modal fade" id="reassignModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
    aria-labelledby="reassignModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reassignModalLabel">Reassign Laptop</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('laptop_tracker.reassign', $laptop->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Select New Employee</label>
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            @foreach ($employees as $employee)
                            <option value="{{ $employee->id }}">
                                {{ $employee->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="notes">Reassignment Notes</label>
                        <textarea id="notes" name="notes" class="form-control" rows="3">{{ old('notes') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Reassign</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
    aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Delete Laptop Record</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this laptop record?
            </div>
            <div class="modal-footer">
                <form action="{{ route('laptop_tracker.destroy', $laptop->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- History Modal -->
<div class="modal fade" id="historyModal-{{ $laptop->id }}" tabindex="-1" role="dialog"
    aria-labelledby="historyModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="historyModalLabel">Laptop History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Employee</th>
                            <th>Date</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($laptop->history as $history)
                        <tr>
                            <td>{{ ucfirst($history->action) }}</td>
                            <td>{{ $history->employee->name }}</td>
                            <td>{{ \Carbon\Carbon::parse($history->date)->format('Y-m-d') }}</td>
                            <td>{{ $history->notes }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Include other modals like repair, accessory management, etc. here -->
@include('pages.laptop_tracker.repairs.repairModel')
@include('pages.laptop_tracker.repairs.repairHistoryModel')
@include('pages.laptop_tracker.repairs.editRepairModel')
@include('pages.laptop_tracker.repairs.deleteRepairModel')

@include('pages.laptop_tracker.accessories.viewModel')
@include('pages.laptop_tracker.accessories.addModel')
@include('pages.laptop_tracker.accessories.deleteModel')
@include('pages.laptop_tracker.accessories.editModel')

@endforeach

<script>
    $(document).on('show.bs.modal', '.modal', function () {
        var zIndex = 1040 + (10 * $('.modal:visible').length);
        $(this).css('z-index', zIndex);
        setTimeout(function () {
            $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
        }, 0);
    });

    $(document).on('hidden.bs.modal', '.modal', function () {
        if ($('.modal:visible').length) {
            $('body').addClass('modal-open');
        }
    });
</script>

@endsection
