@extends('layouts.master')

@section('content')
<div class="col-sm-12 col-md-12 full-width-content">
    <h3 class="heading">Active Laptops for {{ $department }}</h3>

    <form action="{{ route('laptop_tracker.index') }}" method="GET" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by Serial No or Employee Name" value="{{ request('search') }}">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>

    @if(session('success'))
    <div id="response-message" class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Assigned To (Employee)</th>
                <th>Serial Number</th>
                <th>Laptop Type</th>
                <th>Company Name</th>
                <th>Assign Date</th>
                <th>Microsoft Account</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($activeLaptops as $laptop)
            <tr>
                <td>{{ $laptop->employee ? $laptop->employee->name : 'Unassigned' }}</td>
                <td>{{ $laptop->serial_number }}</td>
                <td>{{ ucfirst($laptop->laptop_type) }}</td>
                <td>{{ $laptop->company_name }}</td>
                <td>{{ $laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A' }}</td>
                <td>{{ $laptop->microsoft_account }}</td>
                <td>
                    <a href="{{ route('laptop_tracker.edit', $laptop->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i>
                    </a>
                    <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#viewModal-{{ $laptop->id }}">
                        <i class="fas fa-eye"></i>
                    </button>
                    <button class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#reassignModal-{{ $laptop->id }}">
                        <i class="fas fa-exchange-alt"></i> Reassign
                    </button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $activeLaptops->links() }} <!-- Pagination -->
</div>

@foreach($activeLaptops as $laptop)
<!-- View Modal -->
<div class="modal fade" id="viewModal-{{ $laptop->id }}" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">Laptop Details - {{ $laptop->serial_number }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <tr><th>Serial Number</th><td>{{ $laptop->serial_number }}</td></tr>
                    <tr><th>Laptop Type</th><td>{{ ucfirst($laptop->laptop_type) }}</td></tr>
                    <tr><th>Company Name</th><td>{{ $laptop->company_name }}</td></tr>
                    <tr><th>Assign Date</th><td>{{ $laptop->assign_date ? \Carbon\Carbon::parse($laptop->assign_date)->format('Y-m-d') : 'N/A' }}</td></tr>
                    <tr><th>Microsoft Account</th><td>{{ $laptop->microsoft_account }}</td></tr>
                    <tr><th>Assigned To</th><td>{{ $laptop->employee ? $laptop->employee->name : 'Unassigned' }}</td></tr>
                    <tr><th>Host Info</th><td>{{ $laptop->host_info }}</td></tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Reassign Modal -->
<div class="modal fade" id="reassignModal-{{ $laptop->id }}" tabindex="-1" role="dialog" aria-labelledby="reassignModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reassignModalLabel">Reassign Laptop</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('laptop_tracker.reassign', $laptop->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="form-group">
                        <label for="employee_id">Select New Employee</label>
                        <select id="employee_id" name="employee_id" class="form-control" required>
                            @foreach($employees as $employee)
                                <option value="{{ $employee->id }}">
                                    {{ $employee->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="notes">Reassignment Notes</label>
                        <textarea id="notes" name="notes" class="form-control" rows="3">{{ old('notes') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Reassign</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endforeach
@endsection
