@extends('layouts.master')

@section('content')
    <div id="jCrumbs" class="breadCrumb module">
        <ul>
            <li><a href="{{ route('office.dashboard') }}"><i class="glyphicon glyphicon-home"></i></a></li>
            <li><a href="#">Follow-up</a></li>
            <li><a href="#">Pt. Details</a></li>
            <li><a href="{{route('followup.create')}}">Add New</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-sm-12 col-md-12">
            <h3 class="heading">Follow-up Patient Datatable</h3>
            <input type="text" id="searchInput" class="form-control mb-3" placeholder="Search...">
            <table class="table table-bordered table-striped table_vam" id="dt_gal">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Dr. Name</th>
                        <th>Dept. Name</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($followupPt as $camp)
                        <tr>
                            <td>{{ $camp->name }}</td>
                            <td>{{ $camp->phone }}</td>
                            <td>{{ $camp->doctor }}</td>
                            <td>{{ $camp->department }}</td>
                            <td>{{ $camp->status }}</td>
                            <td>
                                <a href="#" title="Edit"><i class="splashy-document_letter_edit"></i></a>
                                <a href="#" title="Accept"><i class="splashy-document_letter_okay"></i></a>
                                <a href="#" title="Remove"><i class="splashy-document_letter_remove"></i></a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            var table = $('#dt_gal').DataTable({
                "paging": true,
                "searching": true,
                "ordering": true
            });

            // Custom search input
            $('#searchInput').on('keyup', function() {
                table.search(this.value).draw();
            });
        });
    </script>
@endsection
