<!DOCTYPE html>
<html lang="en" class="login_page">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <title>CA Software</title>
     <!-- Bootstrap framework -->
     <link rel="stylesheet" href="{{asset('assets/bootstrap/css/bootstrap.min.css')}}" />
     <!-- jQuery UI theme -->
         <link rel="stylesheet" href="{{asset('assets/lib/jquery-ui/css/Aristo/Aristo.css')}}" />
     <!-- breadcrumbs -->
         <link rel="stylesheet" href="{{asset('assets/lib/jBreadcrumbs/css/BreadCrumb.css')}}" />
     <!-- tooltips-->
         <link rel="stylesheet" href="{{asset('assets/lib/qtip2/jquery.qtip.min.css')}}" />
     <!-- colorbox -->
         <link rel="stylesheet" href="{{asset('assets/lib/colorbox/colorbox.css')}}" />
     <!-- code prettify -->
         <link rel="stylesheet" href="{{asset('assets/lib/google-code-prettify/prettify.css')}}" />
     <!-- sticky notifications -->
         <link rel="stylesheet" href="{{asset('assets/lib/sticky/sticky.css')}}" />
     <!-- aditional icons -->
         <link rel="stylesheet" href="{{asset('assets/img/splashy/splashy.css')}}" />
     <!-- flags -->
         <link rel="stylesheet" href="{{asset('assets/img/flags/flags.css')}}" />
     <!-- datatables -->
         <link rel="stylesheet" href="{{asset('assets/lib/datatables/extras/TableTools/media/css/TableTools.css')}}">
    
     <!-- font-awesome -->
         <link rel="stylesheet" href="{{asset('assets/img/font-awesome/css/font-awesome.min.css')}}" />
     <!-- calendar -->
         <link rel="stylesheet" href="{{asset('assets/lib/fullcalendar/fullcalendar_gebo.css')}}" />
    
     <!-- main styles -->
         <link rel="stylesheet" href="{{asset('assets/css/style.css')}}" />
     <!-- theme color-->
         <link rel="stylesheet" href="{{asset('assets/css/blue.css')}}" id="link_theme" />
    
         <link href="https://fonts.googleapis.com/css?family=PT+Sans" rel='stylesheet' type='text/css'>
    
     <!-- favicon -->
         <link rel="shortcut icon" href="favicon.ico" />
    
     <!--[if lte IE 8]>
         <link rel="stylesheet" href="css/ie.css" />
     <![endif]-->
    
    
    </head>

<body>

    <div class="login_box">

        <form action="{{route('store.index')}}" method="post" id="login_form">
            @csrf
            <div class="top_b" style="text-align: center">Madalasa Hospital Software</div>
            @if ($errors->any())
            <div class="alert alert-danger alert-login">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
         
            <div class="cnt_b">
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon input-sm"><i class="glyphicon glyphicon-user"></i></span>
                        <select name="role" id="" class="form-control input-sm"> 
                            <option value="">-Select-</option>
                            <option value="superadmin">Super Admin</option>
                            <option value="admin">Admin</option>
                            <option value="laptop_tracker">Laptop Tracker</option>
                            <option value="camp">Camp</option>
                            <option value="followup">Follow Up</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon input-sm"><i class="glyphicon glyphicon-user"></i></span>
                        <input type="email" name="email" class="form-control input-sm" placeholder="Email" required>
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                        <span class="input-group-addon input-sm"><i class="glyphicon glyphicon-lock"></i></span>
                        <input class="form-control input-sm" type="password" id="password" name="password"
                            placeholder="Password" value="password" />
                    </div>
                </div>
                <div class="form-group">
                    <div class="checkbox"><label><input type="checkbox" /> Remember me</label></div>
                </div>
            </div>
            <div class="btm_b clearfix">
                <button class="btn btn-default btn-sm pull-right" type="submit">Sign In</button>
                <span class="link_reg"><a href="#reg_form">Not able to Login? Contact Now</a></span>
            </div>
        </form>

    

    </div>

    <script src="{{asset('assets/js/jquery.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.actual.min.js')}}"></script>
    <script src="{{asset('assets/lib/validation/jquery.validate.js')}}"></script>
    <script src="{{asset('assets/bootstrap/js/bootstrap.min.js')}}"></script>
    <script>
        $(document).ready(function() {

            //* boxes animation
            form_wrapper = $('.login_box');

            function boxHeight() {
                form_wrapper.animate({
                    marginTop: (-(form_wrapper.height() / 2) - 24)
                }, 400);
            };
            form_wrapper.css({
                marginTop: (-(form_wrapper.height() / 2) - 24)
            });
            $('.linkform a,.link_reg a').on('click', function(e) {
                var target = $(this).attr('href'),
                    target_height = $(target).actual('height');
                $(form_wrapper).css({
                    'height': form_wrapper.height()
                });
                $(form_wrapper.find('form:visible')).fadeOut(400, function() {
                    form_wrapper.stop().animate({
                        height: target_height,
                        marginTop: (-(target_height / 2) - 24)
                    }, 500, function() {
                        $(target).fadeIn(400);
                        $('.links_btm .linkform').toggle();
                        $(form_wrapper).css({
                            'height': ''
                        });
                    });
                });
                e.preventDefault();
            });

            //* validation
            $('#login_form').validate({
                onkeyup: false,
                errorClass: 'error',
                validClass: 'valid',
                rules: {
                    username: {
                        required: true,
                        minlength: 3
                    },
                    password: {
                        required: true,
                        minlength: 3
                    }
                },
                highlight: function(element) {
                    $(element).closest('.form-group').addClass("f_error");
                    setTimeout(function() {
                        boxHeight()
                    }, 200)
                },
                unhighlight: function(element) {
                    $(element).closest('.form-group').removeClass("f_error");
                    setTimeout(function() {
                        boxHeight()
                    }, 200)
                },
                errorPlacement: function(error, element) {
                    $(element).closest('.form-group').append(error);
                }
            });
        });
    </script>
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o),
                m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', '../www.google-analytics.com/analytics.js', 'ga');

        ga('create', 'UA-65389904-1', 'auto');
        ga('send', 'pageview');
    </script>
</body>

</html>
