<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Super Admin',
                'email' => 'superadmin@gmail.com',
                'password' => Hash::make('Iso.exe.virus@!!##'),
                'role' => 'superadmin',
            ],
            [
                'name' => 'Admin',
                'email' => 'admin@gmail.com',
                'password' => Hash::make('Iso.exe.virus@1234'),
                'role' => 'admin',
            ],
            [
                'name' => 'Camp',
                'email' => 'camp@gmail.com',
                'password' => Hash::make('Exe.virus@1234'),
                'role' => 'camp',
            ],
            [
                'name' => 'Follow Up',
                'email' => 'followup@gmail.com',
                'password' => Hash::make('Exe.virus@followup'),
                'role' => 'followup',
            ],
            [
                'name' => 'Laptop Tracker',
                'email' => 'laptoptracker@gmail.com',
                'password' => Hash::make('Tracker.virus@laptop'),
                'role' => 'laptop_tracker',
            ],
        ];

        foreach ($users as $userData) {
            // Manually check if the user already exists
            $existingUser = User::where('email', $userData['email'])->first();

            if (!$existingUser) {
                // If the user does not exist, create a new one
                User::create($userData);
            } else {
                // If the user exists, optionally update the existing user
                $existingUser->update($userData);
            }
        }
    }
}
