<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeviceTypeToLaptopsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('laptops', function (Blueprint $table) {
            $table->string('device_type')->after('serial_number'); // You can position it wherever it makes sense
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('laptops', function (Blueprint $table) {
            $table->dropColumn('device_type');
        });
    }
}
