<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('camps', function (Blueprint $table) {
            $table->id();
            $table->string('camp_location');
            $table->date('camp_date');
            $table->string('pt_name');
            $table->integer('age')->nullable();
            $table->enum('gender', ['Male', 'Female'])->nullable();
            $table->string('phone')->nullable();
            $table->string('phone_status')->nullable();
            $table->string('bp')->nullable(); 
            $table->string('rbs')->nullable(); 
            $table->string('feedback_status')->nullable();
            $table->text('remark')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('camps');
    }
};
