<?php

namespace App\Http\Controllers;

use App\Models\NewLaptop;
use Illuminate\Http\Request;

class NewLaptopController extends Controller
{
    // List all laptops
    public function index()
    {
        $laptops = NewLaptop::all();
        return view('pages.laptop_tracker.new_laptops.index', compact('laptops'));
    }

    // Show the create form
    public function create()
    {
        return view('pages.laptop_tracker.new_laptops.create');
    }

    // Store a new laptop in the database
    public function store(Request $request)
    {
        // Validate the request
        $data = $request->validate([
            'serial_number' => 'required|string|unique:new_laptops,serial_number',
            'laptop_type' => 'required|string',
            'company_name' => 'required|string',
            'model_name' => 'nullable|string',
            'ram' => 'nullable|string',
            'storage' => 'nullable|string',
            'ssd_hdd' => 'nullable|string',
            'processor' => 'nullable|string',
            'generation' => 'nullable|string',
            'purchase_date' => 'nullable|date',
            'purchase_amount' => 'nullable|numeric',
            'purchase_bill' => 'nullable|file|mimes:jpeg,png,jpg,pdf|max:2048',
            'supplier_name' => 'nullable|string',
            'warranty_status' => 'nullable|string',
            'warranty_expiry_date' => 'nullable|date',
            'asset_tag' => 'nullable|string',
            'notes' => 'nullable|string',
        ]);

        // Handle file upload
        if ($request->hasFile('purchase_bill')) {
            $data['purchase_bill'] = $request->file('purchase_bill')->store('bills', 'public');
        }

        // Create the new laptop entry
        NewLaptop::create($data);

        return redirect()->route('new_laptops.index')->with('success', 'New Laptop added successfully');
    }

    // Show details of a single laptop
    public function show($id)
    {
        $laptop = NewLaptop::findOrFail($id);
        return view('pages.laptop_tracker.new_laptops.show', compact('laptop'));
    }

    // Show the edit form
    public function edit($id)
    {
        $laptop = NewLaptop::findOrFail($id);
        return view('pages.laptop_tracker.new_laptops.edit', compact('laptop'));
    }

    // Update an existing laptop
    public function update(Request $request, $id)
    {
        $laptop = NewLaptop::findOrFail($id);

        // Validate the request
        $data = $request->validate([
            'serial_number' => 'required|string|unique:new_laptops,serial_number,'.$id,
            'laptop_type' => 'required|string',
            'company_name' => 'required|string',
            'model_name' => 'nullable|string',
            'ram' => 'nullable|string',
            'storage' => 'nullable|string',
            'ssd_hdd' => 'nullable|string',
            'processor' => 'nullable|string',
            'generation' => 'nullable|string',
            'purchase_date' => 'nullable|date',
            'purchase_amount' => 'nullable|numeric',
            'purchase_bill' => 'nullable|file|mimes:jpeg,png,jpg,pdf|max:2048',
            'supplier_name' => 'nullable|string',
            'warranty_status' => 'nullable|string',
            'warranty_expiry_date' => 'nullable|date',
            'asset_tag' => 'nullable|string',
            'notes' => 'nullable|string',
        ]);

        // Handle file upload
        if ($request->hasFile('purchase_bill')) {
            $data['purchase_bill'] = $request->file('purchase_bill')->store('bills', 'public');
        }

        // Update the laptop entry
        $laptop->update($data);

        return redirect()->route('new_laptops.index')->with('success', 'Laptop updated successfully');
    }

    // Delete a laptop
    public function destroy($id)
    {
        $laptop = NewLaptop::findOrFail($id);
        $laptop->delete();

        return redirect()->route('new_laptops.index')->with('success', 'Laptop deleted successfully');
    }
}
